/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.tcp;

import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpFrame;

public class SoapTcpChannel {
    private int channelId;
    private String wsURI;
    private List<SoapTcpFrame> frames;

    public SoapTcpChannel(int channelId, String wsURI) {
        this.channelId = channelId;
        this.wsURI = wsURI;
        this.frames = new ArrayList<SoapTcpFrame>();
    }

    public boolean addFrame(SoapTcpFrame frame) {
        if (frame != null && frame.getChannelId() == this.channelId) {
            if (frame.getHeader().getFrameType() == 0) {
                this.frames.clear();
            }
            this.frames.add(frame);
            return true;
        }
        return false;
    }

    public List<SoapTcpFrame> getFrames() {
        return this.frames;
    }

    public void clearFrameBuffer() {
        this.frames.clear();
    }

    public int getChannelId() {
        return this.channelId;
    }

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public String getWsURI() {
        return this.wsURI;
    }

    public void setWsURI(String wsURI) {
        this.wsURI = wsURI;
    }
}

