/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.CallbackLookup;
import org.apache.wss4j.dom.processor.Processor;
import org.apache.wss4j.dom.saml.DOMSAMLUtil;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSecurityEngine {
    private static final Logger LOG = LoggerFactory.getLogger(WSSecurityEngine.class);
    public static final QName BINARY_TOKEN = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "BinarySecurityToken");
    public static final QName USERNAME_TOKEN = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
    public static final QName TIMESTAMP = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp");
    public static final QName SIGNATURE_CONFIRMATION = new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "SignatureConfirmation");
    public static final QName SIGNATURE = new QName("http://www.w3.org/2000/09/xmldsig#", "Signature");
    public static final QName ENCRYPTED_KEY = new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
    public static final QName ENCRYPTED_DATA = new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
    public static final QName REFERENCE_LIST = new QName("http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
    public static final QName SAML_TOKEN = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
    public static final QName SAML2_TOKEN = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
    public static final QName ENCRYPTED_ASSERTION = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedAssertion");
    public static final QName DERIVED_KEY_TOKEN_05_02 = new QName("http://schemas.xmlsoap.org/ws/2005/02/sc", "DerivedKeyToken");
    public static final QName SECURITY_CONTEXT_TOKEN_05_02 = new QName("http://schemas.xmlsoap.org/ws/2005/02/sc", "SecurityContextToken");
    public static final QName DERIVED_KEY_TOKEN_05_12 = new QName("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "DerivedKeyToken");
    public static final QName SECURITY_CONTEXT_TOKEN_05_12 = new QName("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "SecurityContextToken");
    private WSSConfig wssConfig;
    private boolean doDebug;
    private CallbackLookup callbackLookup;

    public final WSSConfig getWssConfig() {
        if (this.wssConfig == null) {
            this.wssConfig = WSSConfig.getNewInstance();
        }
        return this.wssConfig;
    }

    public final WSSConfig setWssConfig(WSSConfig cfg) {
        WSSConfig ret = this.wssConfig;
        this.wssConfig = cfg;
        return ret;
    }

    public void setCallbackLookup(CallbackLookup callbackLookup) {
        this.callbackLookup = callbackLookup;
    }

    public CallbackLookup getCallbackLookup() {
        return this.callbackLookup;
    }

    public List<WSSecurityEngineResult> processSecurityHeader(Document doc, String actor, CallbackHandler cb, Crypto crypto) throws WSSecurityException {
        return this.processSecurityHeader(doc, actor, cb, crypto, crypto);
    }

    public List<WSSecurityEngineResult> processSecurityHeader(Document doc, String actor, CallbackHandler cb, Crypto sigVerCrypto, Crypto decCrypto) throws WSSecurityException {
        this.doDebug = LOG.isDebugEnabled();
        if (this.doDebug) {
            LOG.debug("enter processSecurityHeader()");
        }
        if (actor == null) {
            actor = "";
        }
        List<WSSecurityEngineResult> wsResult = null;
        Element elem = WSSecurityUtil.getSecurityHeader(doc, actor);
        if (elem != null) {
            if (this.doDebug) {
                LOG.debug("Processing WS-Security header for '" + actor + "' actor.");
            }
            wsResult = this.processSecurityHeader(elem, cb, sigVerCrypto, decCrypto);
        }
        return wsResult;
    }

    public List<WSSecurityEngineResult> processSecurityHeader(Element securityHeader, CallbackHandler cb, Crypto sigVerCrypto, Crypto decCrypto) throws WSSecurityException {
        RequestData data = new RequestData();
        data.setWssConfig(this.getWssConfig());
        data.setDecCrypto(decCrypto);
        data.setSigVerCrypto(sigVerCrypto);
        data.setCallbackHandler(cb);
        return this.processSecurityHeader(securityHeader, data);
    }

    public List<WSSecurityEngineResult> processSecurityHeader(Document doc, String actor, RequestData requestData) throws WSSecurityException {
        if (actor == null) {
            actor = "";
        }
        List<WSSecurityEngineResult> wsResult = null;
        Element elem = WSSecurityUtil.getSecurityHeader(doc, actor);
        if (elem != null) {
            if (this.doDebug) {
                LOG.debug("Processing WS-Security header for '" + actor + "' actor.");
            }
            wsResult = this.processSecurityHeader(elem, requestData);
        }
        return wsResult;
    }

    public List<WSSecurityEngineResult> processSecurityHeader(Element securityHeader, RequestData requestData) throws WSSecurityException {
        ArrayList<WSSecurityEngineResult> returnResults = new ArrayList<WSSecurityEngineResult>();
        if (securityHeader == null) {
            return returnResults;
        }
        if (requestData.getWssConfig() == null) {
            requestData.setWssConfig(this.getWssConfig());
        }
        WSDocInfo wsDocInfo = new WSDocInfo(securityHeader.getOwnerDocument());
        wsDocInfo.setCallbackLookup(this.callbackLookup);
        wsDocInfo.setCrypto(requestData.getSigVerCrypto());
        wsDocInfo.setSecurityHeader(securityHeader);
        WSSConfig cfg = this.getWssConfig();
        Node node = securityHeader.getFirstChild();
        boolean foundTimestamp = false;
        while (node != null) {
            Node nextSibling = node.getNextSibling();
            if (1 == node.getNodeType()) {
                QName el = new QName(node.getNamespaceURI(), node.getLocalName());
                if (foundTimestamp && el.equals(TIMESTAMP)) {
                    requestData.getBSPEnforcer().handleBSPRule(BSPRule.R3227);
                } else if (el.equals(TIMESTAMP)) {
                    foundTimestamp = true;
                }
                Processor p = cfg.getProcessor(el);
                if (p != null) {
                    List<WSSecurityEngineResult> results = p.handleToken((Element)node, requestData, wsDocInfo);
                    if (!results.isEmpty()) {
                        returnResults.addAll(0, results);
                    }
                } else if (this.doDebug) {
                    LOG.debug("Unknown Element: " + node.getLocalName() + " " + node.getNamespaceURI());
                }
            }
            if (node.getNextSibling() == null && nextSibling != null && nextSibling.getParentNode() != null) {
                node = nextSibling;
                continue;
            }
            node = node.getNextSibling();
        }
        if (this.wssConfig.isValidateSamlSubjectConfirmation()) {
            Element bodyElement = WSSecurityUtil.findBodyElement(securityHeader.getOwnerDocument());
            DOMSAMLUtil.validateSAMLResults(returnResults, requestData.getTlsCerts(), bodyElement);
        }
        return returnResults;
    }
}

