/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.impl;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.impl.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.util.DatatypeHelper;
import org.w3c.dom.Attr;

public abstract class RequestAbstractTypeUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    @Override
    protected void processAttribute(XMLObject samlObject, Attr attribute) throws UnmarshallingException {
        RequestAbstractType req = (RequestAbstractType)samlObject;
        if (attribute.getLocalName().equals("Version")) {
            req.setVersion(SAMLVersion.valueOf(attribute.getValue()));
        } else if (attribute.getLocalName().equals("ID")) {
            req.setID(attribute.getValue());
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        } else if (attribute.getLocalName().equals("IssueInstant") && !DatatypeHelper.isEmpty((String)attribute.getValue())) {
            req.setIssueInstant(new DateTime((Object)attribute.getValue(), (Chronology)ISOChronology.getInstanceUTC()));
        } else if (attribute.getLocalName().equals("Destination")) {
            req.setDestination(attribute.getValue());
        } else if (attribute.getLocalName().equals("Consent")) {
            req.setConsent(attribute.getValue());
        } else {
            super.processAttribute(samlObject, attribute);
        }
    }

    @Override
    protected void processChildElement(XMLObject parentSAMLObject, XMLObject childSAMLObject) throws UnmarshallingException {
        RequestAbstractType req = (RequestAbstractType)parentSAMLObject;
        if (childSAMLObject instanceof Issuer) {
            req.setIssuer((Issuer)childSAMLObject);
        } else if (childSAMLObject instanceof Signature) {
            req.setSignature((Signature)childSAMLObject);
        } else if (childSAMLObject instanceof Extensions) {
            req.setExtensions((Extensions)childSAMLObject);
        } else {
            super.processChildElement(parentSAMLObject, childSAMLObject);
        }
    }
}

