/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.net.URI;
import javax.crypto.SecretKey;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrant;

public class JwtRequestCodeGrant
extends AuthorizationCodeGrant {
    private static final long serialVersionUID = -3738825769770411453L;
    private JwsSignatureProvider sigProvider;
    private JweEncryptionProvider encryptionProvider;
    private String clientSecret;
    private boolean encryptWithClientSecret;
    private boolean signWithClientSecret;
    private String issuer;

    public JwtRequestCodeGrant() {
    }

    public JwtRequestCodeGrant(String issuer) {
        this.issuer = issuer;
    }

    public JwtRequestCodeGrant(String code, String issuer) {
        super(code);
        this.issuer = issuer;
    }

    public JwtRequestCodeGrant(String code, URI uri, String issuer) {
        super(code, uri);
        this.issuer = issuer;
    }

    public void setSignatureProvider(JwsSignatureProvider signatureProvider) {
        this.sigProvider = signatureProvider;
    }

    public void setEncryptionProvider(JweEncryptionProvider encProvider) {
        this.encryptionProvider = encProvider;
    }

    protected JwsSignatureProvider getInitializedSigProvider() {
        if (this.sigProvider != null) {
            return this.sigProvider;
        }
        if (this.signWithClientSecret) {
            byte[] hmac = CryptoUtils.decodeSequence((String)this.clientSecret);
            return JwsUtils.getHmacSignatureProvider((byte[])hmac, (String)"HS256");
        }
        return JwsUtils.loadSignatureProvider((boolean)true);
    }

    @Override
    public MultivaluedMap<String, String> toMap() {
        String request = this.getRequest();
        MetadataMap newMap = new MetadataMap();
        newMap.putSingle((Object)"request", (Object)request);
        return newMap;
    }

    public String getRequest() {
        MultivaluedMap<String, String> map = super.toMap();
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(this.issuer);
        for (String key : map.keySet()) {
            claims.setClaim(key, map.getFirst((Object)key));
        }
        JwsJwtCompactProducer producer = new JwsJwtCompactProducer(claims);
        JwsSignatureProvider theSigProvider = this.getInitializedSigProvider();
        String request = producer.signWith(theSigProvider);
        JweEncryptionProvider theEncryptionProvider = this.getInitializedEncryptionProvider();
        if (theEncryptionProvider != null) {
            request = theEncryptionProvider.encrypt(StringUtils.toBytesUTF8((String)request), null);
        }
        return request;
    }

    protected JweEncryptionProvider getInitializedEncryptionProvider() {
        if (this.encryptionProvider != null) {
            return this.encryptionProvider;
        }
        if (this.encryptWithClientSecret) {
            SecretKey key = CryptoUtils.decodeSecretKey((String)this.clientSecret);
            return JweUtils.getDirectKeyJweEncryption((SecretKey)key, (String)"A128GCM");
        }
        return JweUtils.loadEncryptionProvider((boolean)false);
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setEncryptWithClientSecret(boolean encryptWithClientSecret) {
        if (this.signWithClientSecret) {
            throw new SecurityException();
        }
        this.encryptWithClientSecret = encryptWithClientSecret;
    }

    public void setSignWithClientSecret(boolean signWithClientSecret) {
        if (this.encryptWithClientSecret) {
            throw new SecurityException();
        }
        this.signWithClientSecret = signWithClientSecret;
    }
}

