/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xjc.ts;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.io.IOException;
import java.util.logging.Logger;
import org.xml.sax.ErrorHandler;

public class ToStringPlugin {
    private static final Logger LOG = Logger.getLogger(ToStringPlugin.class.getName());
    private String styleFieldName = "DEFAULT_STYLE";
    private String styleClassName = "org.apache.cxf.xjc.runtime.JAXBToStringStyle";
    private boolean active;

    public String getOptionName() {
        return "Xts";
    }

    public String getUsage() {
        return "  -Xts                 : Activate plugin to add a toString() method to generated classes\n         equivalent to: -Xts:style:org.apache.cxf.xjc.runtime.JAXBToStringStyle.DEFAULT_STYLE\n  -Xts:style:multiline : Have toString produce multi line output\n         equivalent to: -Xts:style:org.apache.cxf.xjc.runtime.JAXBToStringStyle.MULTI_LINE_STYLE\n  -Xts:style:simple    : Have toString produce single line terse output\n         equivalent to: -Xts:style:org.apache.cxf.xjc.runtime.JAXBToStringStyle.SIMPLE_STYLE\n  -Xts:style:org.apache.commons.lang.builder.ToStringStyle.FIELD : The full class+field\n         name of the ToStringStyle to use.";
    }

    public int parseArgument(Options opt, String[] args, int index, Plugin plugin) throws BadCommandLineException, IOException {
        int ret = 0;
        if (args[index].startsWith("-Xts")) {
            ret = 1;
            if (args[index].startsWith("-Xts:style:")) {
                String v = args[index].substring("-Xts:style:".length());
                if ("multiline".equals(v)) {
                    this.styleFieldName = "MULTI_LINE_STYLE";
                } else if ("simple".equals(v)) {
                    this.styleFieldName = "SIMPLE_STYLE";
                } else {
                    int idx = v.lastIndexOf(46);
                    this.styleFieldName = v.substring(idx + 1);
                    this.styleClassName = v.substring(0, idx);
                }
            }
            if (!opt.activePlugins.contains(plugin)) {
                opt.activePlugins.add(plugin);
            }
            this.active = true;
        }
        return ret;
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        LOG.fine("Running toString() plugin.");
        if (!this.active) {
            return true;
        }
        JClass toStringDelegateImpl = outline.getCodeModel().ref("org.apache.commons.lang.builder.ToStringBuilder");
        JClass styleClass = outline.getCodeModel().ref(this.styleClassName);
        JFieldRef toStringDelegateStyleParam = styleClass.staticRef(this.styleFieldName);
        for (ClassOutline co : outline.getClasses()) {
            this.addToStringMethod(co, toStringDelegateImpl, toStringDelegateStyleParam);
        }
        return true;
    }

    private void addToStringMethod(ClassOutline co, JClass delegateImpl, JFieldRef toStringDelegateStyleParam) {
        JDefinedClass implementation = co.implClass;
        JMethod toStringMethod = implementation.method(1, String.class, "toString");
        JInvocation invoke = delegateImpl.staticInvoke("reflectionToString");
        invoke.arg(JExpr._this());
        invoke.arg((JExpression)toStringDelegateStyleParam);
        toStringMethod.body()._return((JExpression)invoke);
        JDocComment doc = toStringMethod.javadoc();
        doc.add((Object)"Generates a String representation of the contents of this type.");
        doc.add((Object)"\nThis is an extension method, produced by the 'ts' xjc plugin");
        toStringMethod.annotate(Override.class);
    }

    public void onActivated(Options opts) {
        this.active = true;
    }
}

