/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.core.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jca.core.classloader.FireWallClassLoader;
import org.apache.cxf.jca.core.classloader.Handler;
import org.apache.cxf.jca.core.classloader.PlugInClassLoaderHelper;

public class PlugInClassLoader
extends SecureClassLoader {
    private static final Logger LOG = LogUtils.getL7dLogger(PlugInClassLoader.class);
    private static final String FILE_COLON = "file:";
    private static final String ZIP_COLON = "zip:";
    private static final String URL_SCHEME_COLON = "classloader:";
    private static final String JARS_PROPS_FILE = "jars.properties";
    private static final String FILTERS_PROPS_FILE = "filters.properties";
    private static final String NEFILTERS_PROPS_FILE = "negativefilters.properties";
    private String[] jarUrls = new String[0];
    private final ProtectionDomain protectionDomain;
    private final ClassLoader ploader;

    public PlugInClassLoader(ClassLoader p) throws IOException {
        super(new FireWallClassLoader(p, PlugInClassLoader.getFilterList(p, FILTERS_PROPS_FILE), PlugInClassLoader.getFilterList(p, NEFILTERS_PROPS_FILE)));
        this.ploader = p;
        this.protectionDomain = this.getClass().getProtectionDomain();
        this.jarUrls = this.loadUrls(p);
        this.processJarUrls(this.jarUrls);
    }

    private void processJarUrls(String[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            if (!urls[i].startsWith(ZIP_COLON)) continue;
            urls[i] = FILE_COLON + urls[i].substring(ZIP_COLON.length());
        }
    }

    private static String[] getFilterList(ClassLoader parent, String propFile) throws IOException {
        Properties filtersProps = PlugInClassLoader.getProperties(parent, propFile);
        Iterator<Object> i = filtersProps.keySet().iterator();
        while (i.hasNext()) {
            LOG.config("get Filter " + propFile + "::" + (String)i.next());
        }
        return filtersProps.keySet().toArray(new String[filtersProps.keySet().size()]);
    }

    private static Properties getProperties(ClassLoader parent, String propsFileName) throws IOException {
        InputStream in = parent.getResourceAsStream(propsFileName);
        if (null == in && null == (in = PlugInClassLoader.class.getResourceAsStream(propsFileName))) {
            String msg = "Internal rar classloader failed to locate configuration resource: " + propsFileName;
            IOException ioe = new IOException(msg);
            LOG.warning(ioe.toString());
            throw ioe;
        }
        Properties props = new Properties();
        props.load(in);
        LOG.fine("Contents: " + propsFileName + props);
        return props;
    }

    private String[] loadUrls(ClassLoader parent) throws IOException {
        ArrayList<String> urlList = new ArrayList<String>();
        Properties props = PlugInClassLoader.getProperties(parent, JARS_PROPS_FILE);
        LOG.fine(props.toString());
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            URL url = parent.getResource(key);
            if (url == null) continue;
            LOG.config(url.toString());
            urlList.add(url.toString());
        }
        return urlList.toArray(new String[urlList.size()]);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        LOG.fine("findClass " + path);
        byte[] bytes = null;
        for (int i = 0; i < this.jarUrls.length; ++i) {
            String fullpath = this.jarUrls[i] + "!/" + path;
            try {
                bytes = PlugInClassLoaderHelper.getResourceAsBytes(fullpath);
                if (bytes == null) continue;
                break;
            }
            catch (IOException ex) {
                LOG.fine("findClass: " + name + ": " + ex.toString());
            }
        }
        if (bytes != null) {
            return this.defineClass(name, bytes, 0, bytes.length, this.protectionDomain);
        }
        LOG.config("can't find name " + name + " , try to using the ploader");
        Class<?> result = this.ploader.loadClass(name);
        if (null == result) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    @Override
    protected URL findResource(String name) {
        LOG.fine("findResource: " + name);
        for (int i = 0; i < this.jarUrls.length; ++i) {
            String fullpath = this.jarUrls[i] + "!/" + name;
            if (!PlugInClassLoaderHelper.hasResource(fullpath)) continue;
            return this.genURL(fullpath);
        }
        return null;
    }

    protected URL genURL(String path) {
        URL url = null;
        String urlString = URL_SCHEME_COLON + path;
        try {
            url = new URL(null, urlString, new Handler());
        }
        catch (MalformedURLException mue) {
            LOG.warning(mue.toString());
        }
        return url;
    }
}

