/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcp.xml.dsig.internal.dom;

import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.apache.jcp.xml.dsig.internal.dom.BaseStructure;
import org.apache.jcp.xml.dsig.internal.dom.DOMKeyName;
import org.apache.jcp.xml.dsig.internal.dom.DOMKeyValue;
import org.apache.jcp.xml.dsig.internal.dom.DOMPGPData;
import org.apache.jcp.xml.dsig.internal.dom.DOMRetrievalMethod;
import org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import org.apache.jcp.xml.dsig.internal.dom.DOMX509Data;
import org.apache.jcp.xml.dsig.internal.dom.Marshaller;
import org.apache.jcp.xml.dsig.internal.dom.XmlWriter;
import org.apache.jcp.xml.dsig.internal.dom.XmlWriterToTree;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMKeyInfo
extends BaseStructure
implements KeyInfo {
    private final String id;
    private final List<XMLStructure> keyInfoTypes;

    public static List<XMLStructure> getContent(KeyInfo ki) {
        return ki.getContent();
    }

    public DOMKeyInfo(List<? extends XMLStructure> content, String id) {
        if (content == null) {
            throw new NullPointerException("content cannot be null");
        }
        this.keyInfoTypes = Collections.unmodifiableList(new ArrayList<XMLStructure>(content));
        if (this.keyInfoTypes.isEmpty()) {
            throw new IllegalArgumentException("content cannot be empty");
        }
        int size = this.keyInfoTypes.size();
        for (int i = 0; i < size; ++i) {
            if (this.keyInfoTypes.get(i) instanceof XMLStructure) continue;
            throw new ClassCastException("content[" + i + "] is not a valid KeyInfo type");
        }
        this.id = id;
    }

    public DOMKeyInfo(Element kiElem, XMLCryptoContext context, Provider provider) throws MarshalException {
        Node firstChild;
        this.id = DOMUtils.getIdAttributeValue(kiElem, "Id");
        ArrayList<XMLStructure> content = new ArrayList<XMLStructure>();
        if (firstChild == null) {
            throw new MarshalException("KeyInfo must contain at least one type");
        }
        for (firstChild = kiElem.getFirstChild(); firstChild != null; firstChild = firstChild.getNextSibling()) {
            if (firstChild.getNodeType() != 1) continue;
            Element childElem = (Element)firstChild;
            String localName = childElem.getLocalName();
            String namespace = childElem.getNamespaceURI();
            if (localName.equals("X509Data") && "http://www.w3.org/2000/09/xmldsig#".equals(namespace)) {
                content.add(new DOMX509Data(childElem));
                continue;
            }
            if (localName.equals("KeyName") && "http://www.w3.org/2000/09/xmldsig#".equals(namespace)) {
                content.add(new DOMKeyName(childElem));
                continue;
            }
            if (localName.equals("KeyValue") && "http://www.w3.org/2000/09/xmldsig#".equals(namespace)) {
                content.add(DOMKeyValue.unmarshal(childElem));
                continue;
            }
            if (localName.equals("RetrievalMethod") && "http://www.w3.org/2000/09/xmldsig#".equals(namespace)) {
                content.add(new DOMRetrievalMethod(childElem, context, provider));
                continue;
            }
            if (localName.equals("PGPData") && "http://www.w3.org/2000/09/xmldsig#".equals(namespace)) {
                content.add(new DOMPGPData(childElem));
                continue;
            }
            content.add(new DOMStructure(childElem));
        }
        this.keyInfoTypes = Collections.unmodifiableList(content);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<XMLStructure> getContent() {
        return this.keyInfoTypes;
    }

    @Override
    public void marshal(XMLStructure parent, XMLCryptoContext context) throws MarshalException {
        if (parent == null) {
            throw new NullPointerException("parent is null");
        }
        if (!(parent instanceof DOMStructure)) {
            throw new ClassCastException("parent must be of type DOMStructure");
        }
        this.internalMarshal((DOMStructure)parent, context);
    }

    private void internalMarshal(DOMStructure parent, XMLCryptoContext context) throws MarshalException {
        Node pNode = parent.getNode();
        String dsPrefix = DOMUtils.getSignaturePrefix(context);
        XmlWriterToTree xwriter = new XmlWriterToTree(Marshaller.getMarshallers(), pNode);
        DOMKeyInfo.marshalInternal(xwriter, this, dsPrefix, context, true);
    }

    public static void marshal(XmlWriter xwriter, KeyInfo ki, String dsPrefix, XMLCryptoContext context) throws MarshalException {
        DOMKeyInfo.marshalInternal(xwriter, ki, dsPrefix, context, false);
    }

    private static void marshalInternal(XmlWriter xwriter, KeyInfo ki, String dsPrefix, XMLCryptoContext context, boolean declareNamespace) throws MarshalException {
        xwriter.writeStartElement(dsPrefix, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        if (declareNamespace) {
            xwriter.writeNamespace(dsPrefix, "http://www.w3.org/2000/09/xmldsig#");
        }
        xwriter.writeIdAttribute("", "", "Id", ki.getId());
        List<XMLStructure> keyInfoTypes = DOMKeyInfo.getContent(ki);
        for (XMLStructure kiType : keyInfoTypes) {
            xwriter.marshalStructure(kiType, dsPrefix, context);
        }
        xwriter.writeEndElement();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyInfo)) {
            return false;
        }
        KeyInfo oki = (KeyInfo)o;
        boolean idsEqual = this.id == null ? oki.getId() == null : this.id.equals(oki.getId());
        return ((Object)this.keyInfoTypes).equals(oki.getContent()) && idsEqual;
    }

    public int hashCode() {
        int result = 17;
        if (this.id != null) {
            result = 31 * result + this.id.hashCode();
        }
        result = 31 * result + ((Object)this.keyInfoTypes).hashCode();
        return result;
    }
}

