/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.transport.http.netty.server.NettyHttpContextHandler;
import org.apache.cxf.transport.http.netty.server.NettyHttpServerEngine;
import org.apache.cxf.transport.http.netty.server.NettyHttpServletHandler;
import org.apache.cxf.transport.http.netty.server.interceptor.ChannelInterceptor;
import org.apache.cxf.transport.http.netty.server.interceptor.HttpSessionInterceptor;
import org.apache.cxf.transport.http.netty.server.session.DefaultHttpSessionStore;
import org.apache.cxf.transport.http.netty.server.session.HttpSessionStore;
import org.apache.cxf.transport.https.SSLUtils;

public class NettyHttpServletPipelineFactory
extends ChannelInitializer<Channel> {
    private static final Logger LOG = LogUtils.getL7dLogger(NettyHttpServletPipelineFactory.class);
    private final ChannelGroup allChannels = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);
    private final HttpSessionWatchdog watchdog;
    private final TLSServerParameters tlsServerParameters;
    private final boolean supportSession;
    private final Map<String, NettyHttpContextHandler> handlerMap;
    private final int maxChunkContentSize;
    private final EventExecutorGroup applicationExecutor;
    private final NettyHttpServerEngine nettyHttpServerEngine;

    public NettyHttpServletPipelineFactory(TLSServerParameters tlsServerParameters, boolean supportSession, int threadPoolSize, int maxChunkContentSize, Map<String, NettyHttpContextHandler> handlerMap, NettyHttpServerEngine engine) {
        this.supportSession = supportSession;
        this.watchdog = new HttpSessionWatchdog();
        this.handlerMap = handlerMap;
        this.tlsServerParameters = tlsServerParameters;
        this.maxChunkContentSize = maxChunkContentSize;
        this.nettyHttpServerEngine = engine;
        this.applicationExecutor = new DefaultEventExecutorGroup(threadPoolSize);
    }

    public Map<String, NettyHttpContextHandler> getHttpContextHandlerMap() {
        return this.handlerMap;
    }

    public ChannelGroup getAllChannels() {
        return this.allChannels;
    }

    public NettyHttpContextHandler getNettyHttpHandler(String url) {
        Set<String> keySet = this.handlerMap.keySet();
        for (String key : keySet) {
            if (!url.startsWith(key)) continue;
            return this.handlerMap.get(key);
        }
        return null;
    }

    public void start() {
        if (this.supportSession) {
            new Thread(this.watchdog).start();
        }
    }

    public void shutdown() {
        this.allChannels.close().awaitUninterruptibly();
        this.watchdog.stopWatching();
        this.applicationExecutor.shutdownGracefully();
    }

    protected HttpSessionStore getHttpSessionStore() {
        return new DefaultHttpSessionStore();
    }

    protected NettyHttpServletHandler getServletHandler() {
        NettyHttpServletHandler handler = new NettyHttpServletHandler(this);
        handler.addInterceptor(new ChannelInterceptor());
        if (this.supportSession) {
            handler.addInterceptor(new HttpSessionInterceptor(this.getHttpSessionStore()));
        }
        return handler;
    }

    protected ChannelPipeline getDefaulHttpChannelPipeline(Channel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        SslHandler sslHandler = this.configureServerSSLOnDemand();
        if (sslHandler != null) {
            LOG.log(Level.FINE, "Server SSL handler configured and added as an interceptor against the ChannelPipeline: {}", sslHandler);
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(this.maxChunkContentSize));
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("deflater", (ChannelHandler)new HttpContentCompressor());
        pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(this.nettyHttpServerEngine.getReadIdleTime(), this.nettyHttpServerEngine.getWriteIdleTime(), 0));
        return pipeline;
    }

    private SslHandler configureServerSSLOnDemand() throws Exception {
        if (this.tlsServerParameters != null) {
            SSLEngine sslEngine = SSLUtils.createServerSSLEngine((TLSServerParameters)this.tlsServerParameters);
            return new SslHandler(sslEngine);
        }
        return null;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = this.getDefaulHttpChannelPipeline(ch);
        pipeline.addLast(this.applicationExecutor, "handler", (ChannelHandler)this.getServletHandler());
    }

    private class HttpSessionWatchdog
    implements Runnable {
        private boolean shouldStopWatching;

        private HttpSessionWatchdog() {
        }

        @Override
        public void run() {
            while (!this.shouldStopWatching) {
                try {
                    HttpSessionStore store = NettyHttpServletPipelineFactory.this.getHttpSessionStore();
                    if (store != null) {
                        store.destroyInactiveSessions();
                    }
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        public void stopWatching() {
            this.shouldStopWatching = true;
        }
    }
}

