/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server.blueprint;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.cxf.common.jaxb.JAXBContextCache;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.jsse.TLSServerParametersConfig;
import org.apache.cxf.transport.http.netty.server.NettyHttpServerEngine;
import org.apache.cxf.transport.http.netty.server.NettyHttpServerEngineFactory;
import org.apache.cxf.transport.http.netty.server.ThreadingParameters;
import org.apache.cxf.transports.http_netty_server.configuration.NettyHttpServerEngineConfigType;
import org.apache.cxf.transports.http_netty_server.configuration.NettyHttpServerEngineFactoryConfigType;
import org.apache.cxf.transports.http_netty_server.configuration.TLSServerParametersIdentifiedType;
import org.apache.cxf.transports.http_netty_server.configuration.ThreadingParametersIdentifiedType;
import org.apache.cxf.transports.http_netty_server.configuration.ThreadingParametersType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NettyHttpServerEngineFactoryHolder {
    private static final Logger LOG = LogUtils.getL7dLogger(NettyHttpServerEngineFactoryHolder.class);
    private String parsedElement;
    private NettyHttpServerEngineFactory factory;
    private JAXBContext jaxbContext;
    private Set<Class<?>> jaxbClasses;

    public void init() {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            Element element = docFactory.newDocumentBuilder().parse(new ByteArrayInputStream(this.parsedElement.getBytes())).getDocumentElement();
            NettyHttpServerEngineFactoryConfigType config = (NettyHttpServerEngineFactoryConfigType)this.getJaxbObject(element, NettyHttpServerEngineFactoryConfigType.class);
            this.factory = new NettyHttpServerEngineFactory();
            TreeMap<String, ThreadingParameters> threadingParametersMap = new TreeMap<String, ThreadingParameters>();
            if (config.getIdentifiedThreadingParameters() != null) {
                for (ThreadingParametersIdentifiedType threads : config.getIdentifiedThreadingParameters()) {
                    ThreadingParameters rThreads = new ThreadingParameters();
                    String id = threads.getId();
                    rThreads.setThreadPoolSize(threads.getThreadingParameters().getThreadPoolSize());
                    threadingParametersMap.put(id, rThreads);
                }
                this.factory.setThreadingParametersMap(threadingParametersMap);
            }
            TreeMap<String, TLSServerParameters> sslMap = new TreeMap<String, TLSServerParameters>();
            if (config.getIdentifiedTLSServerParameters() != null) {
                for (TLSServerParametersIdentifiedType t : config.getIdentifiedTLSServerParameters()) {
                    try {
                        TLSServerParametersConfig parameter = new TLSServerParametersConfig(t.getTlsServerParameters());
                        sslMap.put(t.getId(), (TLSServerParameters)parameter);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not configure TLS for id " + t.getId(), e);
                    }
                }
                this.factory.setTlsServerParameters(sslMap);
            }
            ArrayList<NettyHttpServerEngine> engineList = new ArrayList<NettyHttpServerEngine>();
            for (NettyHttpServerEngineConfigType engine : config.getEngine()) {
                NettyHttpServerEngine eng = new NettyHttpServerEngine();
                if (engine.getHost() != null && !StringUtils.isEmpty((String)engine.getHost())) {
                    eng.setHost(engine.getHost());
                }
                if (engine.getReadIdleTime() != null) {
                    eng.setReadIdleTime(engine.getReadIdleTime());
                }
                if (engine.getWriteIdleTime() != null) {
                    eng.setWriteIdleTime(engine.getWriteIdleTime());
                }
                if (engine.getMaxChunkContentSize() != null) {
                    eng.setMaxChunkContentSize(engine.getMaxChunkContentSize());
                }
                if (engine.getPort() != null) {
                    eng.setPort(engine.getPort());
                }
                if (engine.isSessionSupport() != null) {
                    eng.setSessionSupport(engine.isSessionSupport());
                }
                if (engine.getThreadingParameters() != null) {
                    ThreadingParametersType threads = engine.getThreadingParameters();
                    ThreadingParameters rThreads = new ThreadingParameters();
                    rThreads.setThreadPoolSize(threads.getThreadPoolSize());
                    eng.setThreadingParameters(rThreads);
                }
                if (engine.getTlsServerParameters() != null) {
                    TLSServerParametersConfig parameter = null;
                    try {
                        parameter = new TLSServerParametersConfig(engine.getTlsServerParameters());
                        eng.setTlsServerParameters((TLSServerParameters)parameter);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not configure TLS for engine on  " + eng.getHost() + ":" + eng.getPort(), e);
                    }
                }
                eng.finalizeConfig();
                engineList.add(eng);
            }
            this.factory.setEnginesList(engineList);
            this.factory.initComplete();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not process configuration.", e);
        }
    }

    public void destroy() {
        this.factory.postShutdown();
        this.jaxbClasses.clear();
        this.jaxbContext = null;
    }

    public String getParsedElement() {
        return this.parsedElement;
    }

    public void setParsedElement(String parsedElement) {
        this.parsedElement = parsedElement;
    }

    protected Object getJaxbObject(Element parent, Class<?> c) {
        try {
            Unmarshaller umr = this.getContext(c).createUnmarshaller();
            JAXBElement ele = (JAXBElement)umr.unmarshal((Node)parent);
            return ele.getValue();
        }
        catch (JAXBException e) {
            LOG.warning("Unable to parse property due to " + (Object)((Object)e));
            return null;
        }
    }

    protected synchronized JAXBContext getContext(Class<?> cls) {
        if (this.jaxbContext == null || this.jaxbClasses == null || !this.jaxbClasses.contains(cls)) {
            try {
                HashSet tmp = new HashSet();
                if (this.jaxbClasses != null) {
                    tmp.addAll(this.jaxbClasses);
                }
                JAXBContextCache.addPackage(tmp, (String)PackageUtils.getPackageName(cls), (ClassLoader)(cls == null ? this.getClass().getClassLoader() : cls.getClassLoader()));
                if (cls != null) {
                    boolean hasOf = false;
                    for (Class clazz : tmp) {
                        if (clazz.getPackage() != cls.getPackage() || !"ObjectFactory".equals(clazz.getSimpleName())) continue;
                        hasOf = true;
                    }
                    if (!hasOf) {
                        tmp.add(cls);
                    }
                }
                JAXBContextCache.scanPackages(tmp);
                JAXBContextCache.CachedContextAndSchemas ccs = JAXBContextCache.getCachedContextAndSchemas(tmp, null, null, null, (boolean)false);
                this.jaxbClasses = ccs.getClasses();
                this.jaxbContext = ccs.getContext();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return this.jaxbContext;
    }
}

