/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.authorization;

import java.security.Principal;
import java.util.Set;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.SAMLUtils;
import org.apache.cxf.rs.security.saml.assertion.Subject;
import org.apache.cxf.rs.security.saml.authorization.SecurityContextProvider;
import org.apache.cxf.rs.security.saml.authorization.SubjectPrincipal;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.rt.security.saml.SAMLSecurityContext;
import org.apache.cxf.security.SecurityContext;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.w3c.dom.Element;

public class SecurityContextProviderImpl
implements SecurityContextProvider {
    private static final String ROLE_QUALIFIER_PROPERTY = "org.apache.cxf.saml.claims.role.qualifier";
    private static final String ROLE_NAMEFORMAT_PROPERTY = "org.apache.cxf.saml.claims.role.nameformat";

    @Override
    public SecurityContext getSecurityContext(Message message, SamlAssertionWrapper wrapper) {
        ClaimCollection claims = this.getClaims(wrapper);
        Subject subject = this.getSubject(message, wrapper, claims);
        SecurityContext securityContext = this.doGetSecurityContext(message, subject, claims);
        if (securityContext instanceof SAMLSecurityContext) {
            Element assertionElement = wrapper.getElement();
            ((SAMLSecurityContext)securityContext).setAssertionElement(assertionElement);
        }
        return securityContext;
    }

    protected ClaimCollection getClaims(SamlAssertionWrapper wrapper) {
        return org.apache.cxf.rt.security.saml.SAMLUtils.getClaims((SamlAssertionWrapper)wrapper);
    }

    protected Subject getSubject(Message message, SamlAssertionWrapper wrapper, ClaimCollection claims) {
        return SAMLUtils.getSubject(message, wrapper);
    }

    protected SecurityContext doGetSecurityContext(Message message, Subject subject, ClaimCollection claims) {
        String defaultRoleName = (String)message.getContextualProperty(ROLE_QUALIFIER_PROPERTY);
        String defaultNameFormat = (String)message.getContextualProperty(ROLE_NAMEFORMAT_PROPERTY);
        String subjectPrincipalName = this.getSubjectPrincipalName(subject, claims);
        SubjectPrincipal subjectPrincipal = new SubjectPrincipal(subjectPrincipalName, subject);
        String roleName = defaultRoleName == null ? "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role" : defaultRoleName;
        String nameFormat = defaultNameFormat == null ? "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified" : defaultNameFormat;
        Set roles = org.apache.cxf.rt.security.saml.SAMLUtils.parseRolesFromClaims((ClaimCollection)claims, (String)roleName, (String)nameFormat);
        SAMLSecurityContext context = new SAMLSecurityContext((Principal)((Object)subjectPrincipal), roles, claims);
        return context;
    }

    protected String getSubjectPrincipalName(Subject subject, ClaimCollection claims) {
        return subject.getName();
    }
}

