/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.jwe.JweCompactProducer;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionState;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweOutputStream;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;

@Priority(value=1001)
public class JweWriterInterceptor
implements WriterInterceptor {
    private JweEncryptionProvider encryptionProvider;
    private boolean contentTypeRequired = true;
    private boolean useJweOutputStream;

    public void aroundWriteTo(WriterInterceptorContext ctx) throws IOException, WebApplicationException {
        if (ctx.getEntity() == null) {
            ctx.proceed();
            return;
        }
        OutputStream actualOs = ctx.getOutputStream();
        JweHeaders jweHeaders = new JweHeaders();
        JweEncryptionProvider theEncryptionProvider = this.getInitializedEncryptionProvider(jweHeaders);
        String ctString = null;
        MediaType contentMediaType = ctx.getMediaType();
        if (this.contentTypeRequired && contentMediaType != null) {
            ctString = "application".equals(contentMediaType.getType()) ? contentMediaType.getSubtype() : JAXRSUtils.mediaTypeToString((MediaType)contentMediaType, (String[])new String[0]);
        }
        if (ctString != null) {
            jweHeaders.setContentType(ctString);
        }
        if (this.useJweOutputStream) {
            JweOutputStream jweOutputStream;
            JweEncryptionState encryption = theEncryptionProvider.createJweEncryptionState(new JweEncryptionInput(jweHeaders));
            try {
                JweCompactProducer.startJweContent(actualOs, encryption.getHeaders(), encryption.getContentEncryptionKey(), encryption.getIv());
            }
            catch (IOException ex) {
                throw new SecurityException(ex);
            }
            FilterOutputStream wrappedStream = null;
            wrappedStream = jweOutputStream = new JweOutputStream(actualOs, encryption.getCipher(), encryption.getAuthTagProducer());
            if (encryption.isCompressionSupported()) {
                wrappedStream = new DeflaterOutputStream(jweOutputStream);
            }
            ctx.setOutputStream((OutputStream)wrappedStream);
            ctx.proceed();
            this.setJoseMediaType(ctx);
            jweOutputStream.finalFlush();
        } else {
            CachedOutputStream cos = new CachedOutputStream();
            ctx.setOutputStream((OutputStream)cos);
            ctx.proceed();
            String jweContent = theEncryptionProvider.encrypt(cos.getBytes(), jweHeaders);
            this.setJoseMediaType(ctx);
            IOUtils.copy((InputStream)new ByteArrayInputStream(StringUtils.toBytesUTF8((String)jweContent)), (OutputStream)actualOs);
            actualOs.flush();
        }
    }

    private void setJoseMediaType(WriterInterceptorContext ctx) {
        MediaType joseMediaType = JAXRSUtils.toMediaType((String)"application/jose");
        ctx.setMediaType(joseMediaType);
    }

    protected JweEncryptionProvider getInitializedEncryptionProvider(JweHeaders headers) {
        if (this.encryptionProvider != null) {
            return this.encryptionProvider;
        }
        return JweUtils.loadEncryptionProvider(headers, true);
    }

    public void setUseJweOutputStream(boolean useJweOutputStream) {
        this.useJweOutputStream = useJweOutputStream;
    }

    public void setEncryptionProvider(JweEncryptionProvider encryptionProvider) {
        this.encryptionProvider = encryptionProvider;
    }
}

