/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwa;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum Algorithm {
    HmacSHA256("HS256", 256),
    HmacSHA384("HS384", 384),
    HmacSHA512("HS512", 512),
    SHA256withRSA("RS256", 256),
    SHA384withRSA("RS384", 384),
    SHA512withRSA("RS512", 512),
    SHA256withECDSA("ES256", 256),
    SHA384withECDSA("ES384", 384),
    SHA512withECDSA("ES512", 512),
    RSA_OAEP("RSA-OAEP", "RSA/ECB/OAEPWithSHA-1AndMGF1Padding", -1),
    RSA_OAEP_256("RSA-OAEP-256", "RSA/ECB/OAEPWithSHA-256AndMGF1Padding", -1),
    RSA_1_5("RSA1_5", "RSA/ECB/PKCS1Padding", -1),
    A128KW("A128KW", "AESWrap", 128),
    A192KW("A192KW", "AESWrap", 192),
    A256KW("A256KW", "AESWrap", 256),
    A128GCMKW("A128GCMKW", "AES/GCM/NoPadding", 128),
    A192GCMKW("A192GCMKW", "AES/GCM/NoPadding", 192),
    A256GCMKW("A256GCMKW", "AES/GCM/NoPadding", 256),
    PBES2_HS256_A128KW("PBES2-HS256+A128KW", "AESWrap", 128),
    PBES2_HS384_A192KW("PBES2-HS384+A192KW", "AESWrap", 192),
    PBES2_HS512_A256KW("PBES2-HS512+A256KW", "AESWrap", 256),
    ECDH_ES_A128KW("ECDH-ES+A128KW", "AESWrap", 128),
    ECDH_ES_A192KW("ECDH-ES+A192KW", "AESWrap", 192),
    ECDH_ES_A256KW("ECDH-ES+A256KW", "AESWrap", 256),
    A128GCM("A128GCM", "AES/GCM/NoPadding", 128),
    A192GCM("A192GCM", "AES/GCM/NoPadding", 192),
    A256GCM("A256GCM", "AES/GCM/NoPadding", 256),
    A128CBC_HS256("A128CBC-HS256", "AES/CBC/PKCS7Padding", 128),
    A192CBC_HS384("A192CBC-HS384", "AES/CBC/PKCS7Padding", 192),
    A256CBC_HS512("A256CBC-HS512", "AES/CBC/PKCS7Padding", 256);

    public static final String HMAC_SHA_256_JAVA = "HmacSHA256";
    public static final String HMAC_SHA_384_JAVA = "HmacSHA384";
    public static final String HMAC_SHA_512_JAVA = "HmacSHA512";
    public static final String RS_SHA_256_JAVA = "SHA256withRSA";
    public static final String RS_SHA_384_JAVA = "SHA384withRSA";
    public static final String RS_SHA_512_JAVA = "SHA512withRSA";
    public static final String PS_SHA_256_JAVA = "SHA256withRSAandMGF1";
    public static final String PS_SHA_384_JAVA = "SHA384withRSAandMGF1";
    public static final String PS_SHA_512_JAVA = "SHA512withRSAandMGF1";
    public static final String ES_SHA_256_JAVA = "SHA256withECDSA";
    public static final String ES_SHA_384_JAVA = "SHA384withECDSA";
    public static final String ES_SHA_512_JAVA = "SHA512withECDSA";
    public static final String RSA_OAEP_ALGO_JAVA = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";
    public static final String RSA_OAEP_256_ALGO_JAVA = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
    public static final String RSA_1_5_ALGO_JAVA = "RSA/ECB/PKCS1Padding";
    public static final String AES_ALGO_JAVA = "AES";
    public static final String AES_WRAP_ALGO_JAVA = "AESWrap";
    public static final String AES_GCM_ALGO_JAVA = "AES/GCM/NoPadding";
    public static final String AES_CBC_ALGO_JAVA = "AES/CBC/PKCS7Padding";
    public static final Set<String> HMAC_SIGN_SET;
    public static final Set<String> RSA_SHA_SIGN_SET;
    public static final Set<String> RSA_SHA_PS_SIGN_SET;
    public static final Set<String> EC_SHA_SIGN_SET;
    public static final Set<String> RSA_CEK_SET;
    public static final Set<String> AES_GCM_CEK_SET;
    public static final Set<String> AES_GCM_KW_SET;
    public static final Set<String> AES_KW_SET;
    public static final Set<String> ACBC_HS_SET;
    public static final Set<String> PBES_HS_SET;
    public static final Set<String> ECDH_ES_SET;
    private static final Map<String, String> JAVA_TO_JWT_NAMES;
    private static final Map<String, String> JWT_TO_JAVA_NAMES;
    private final String jwtName;
    private final String javaName;
    private final int keySizeBits;

    private Algorithm(String jwtName, int keySizeBits) {
        this(jwtName, null, keySizeBits);
    }

    private Algorithm(String jwtName, String javaName, int keySizeBits) {
        this.jwtName = jwtName;
        this.javaName = javaName;
        this.keySizeBits = keySizeBits;
    }

    public String getJwtName() {
        return this.jwtName;
    }

    public String getJavaName() {
        return this.javaName == null ? this.name() : this.javaName;
    }

    public String getJavaAlgoName() {
        return Algorithm.stripAlgoProperties(this.getJavaName());
    }

    public int getKeySizeBits() {
        return this.keySizeBits;
    }

    public static String toJwtName(String javaName, int keyBitSize) {
        String name = JAVA_TO_JWT_NAMES.get(javaName);
        if (name == null && javaName.startsWith(AES_ALGO_JAVA)) {
            name = "A" + keyBitSize + "GCM";
        }
        return name;
    }

    public static String toJavaName(String jwtName) {
        return JWT_TO_JAVA_NAMES.get(jwtName);
    }

    public static String toJavaAlgoNameOnly(String jwtName) {
        return Algorithm.stripAlgoProperties(Algorithm.toJavaName(jwtName));
    }

    public static String stripAlgoProperties(String javaName) {
        int index;
        if (javaName != null && (index = javaName.indexOf(47)) != -1) {
            javaName = javaName.substring(0, index);
        }
        return javaName;
    }

    public static boolean isRsa(String algo) {
        return Algorithm.isRsaKeyWrap(algo) || Algorithm.isRsaSign(algo);
    }

    public static boolean isRsaKeyWrap(String algo) {
        return RSA_CEK_SET.contains(algo);
    }

    public static boolean isAesKeyWrap(String algo) {
        return AES_KW_SET.contains(algo);
    }

    public static boolean isAesGcmKeyWrap(String algo) {
        return AES_GCM_KW_SET.contains(algo);
    }

    public static boolean isPbesHsWrap(String algo) {
        return PBES_HS_SET.contains(algo);
    }

    public static boolean isEcdhEsWrap(String algo) {
        return ECDH_ES_SET.contains(algo);
    }

    public static boolean isAesGcm(String algo) {
        return AES_GCM_CEK_SET.contains(algo);
    }

    public static boolean isAesCbcHmac(String algo) {
        return ACBC_HS_SET.contains(algo);
    }

    public static boolean isHmacSign(String algo) {
        return HMAC_SIGN_SET.contains(algo);
    }

    public static boolean isOctet(String algo) {
        return Algorithm.isHmacSign(algo) || Algorithm.isAesCbcHmac(algo) || Algorithm.isAesGcm(algo) || Algorithm.isAesGcmKeyWrap(algo) || Algorithm.isAesKeyWrap(algo);
    }

    public static boolean isRsaSign(String algo) {
        return Algorithm.isRsaShaSign(algo) || Algorithm.isRsaShaPsSign(algo);
    }

    public static boolean isRsaShaSign(String algo) {
        return RSA_SHA_SIGN_SET.contains(algo);
    }

    public static boolean isRsaShaPsSign(String algo) {
        return RSA_SHA_PS_SIGN_SET.contains(algo);
    }

    public static boolean isEcDsaSign(String algo) {
        return EC_SHA_SIGN_SET.contains(algo);
    }

    static {
        HMAC_SIGN_SET = new HashSet<String>(Arrays.asList("HS256", "HS384", "HS512"));
        RSA_SHA_SIGN_SET = new HashSet<String>(Arrays.asList("RS256", "RS384", "RS512"));
        RSA_SHA_PS_SIGN_SET = new HashSet<String>(Arrays.asList("PS256", "PS384", "PS512"));
        EC_SHA_SIGN_SET = new HashSet<String>(Arrays.asList("ES256", "ES384", "ES512"));
        RSA_CEK_SET = new HashSet<String>(Arrays.asList("RSA-OAEP", "RSA-OAEP-256", "RSA1_5"));
        AES_GCM_CEK_SET = new HashSet<String>(Arrays.asList("A128GCM", "A192GCM", "A256GCM"));
        AES_GCM_KW_SET = new HashSet<String>(Arrays.asList("A128GCMKW", "A192GCMKW", "A256GCMKW"));
        AES_KW_SET = new HashSet<String>(Arrays.asList("A128KW", "A192KW", "A256KW"));
        ACBC_HS_SET = new HashSet<String>(Arrays.asList("A128CBC-HS256", "A192CBC-HS384", "A256CBC-HS512"));
        PBES_HS_SET = new HashSet<String>(Arrays.asList(PBES2_HS256_A128KW.getJwtName(), PBES2_HS384_A192KW.getJwtName(), PBES2_HS512_A256KW.getJwtName()));
        ECDH_ES_SET = new HashSet<String>(Arrays.asList(ECDH_ES_A128KW.getJwtName(), ECDH_ES_A192KW.getJwtName(), ECDH_ES_A256KW.getJwtName()));
        JAVA_TO_JWT_NAMES = new HashMap<String, String>();
        JAVA_TO_JWT_NAMES.put(HMAC_SHA_256_JAVA, "HS256");
        JAVA_TO_JWT_NAMES.put(HMAC_SHA_384_JAVA, "HS384");
        JAVA_TO_JWT_NAMES.put(HMAC_SHA_512_JAVA, "HS512");
        JAVA_TO_JWT_NAMES.put(RS_SHA_256_JAVA, "RS256");
        JAVA_TO_JWT_NAMES.put(RS_SHA_384_JAVA, "RS384");
        JAVA_TO_JWT_NAMES.put(RS_SHA_512_JAVA, "RS512");
        JAVA_TO_JWT_NAMES.put(PS_SHA_256_JAVA, "PS256");
        JAVA_TO_JWT_NAMES.put(PS_SHA_384_JAVA, "PS384");
        JAVA_TO_JWT_NAMES.put(PS_SHA_512_JAVA, "PS512");
        JAVA_TO_JWT_NAMES.put(ES_SHA_256_JAVA, "ES256");
        JAVA_TO_JWT_NAMES.put(ES_SHA_384_JAVA, "ES384");
        JAVA_TO_JWT_NAMES.put(ES_SHA_512_JAVA, "ES512");
        JAVA_TO_JWT_NAMES.put(RSA_OAEP_ALGO_JAVA, "RSA-OAEP");
        JAVA_TO_JWT_NAMES.put(RSA_OAEP_256_ALGO_JAVA, "RSA-OAEP-256");
        JAVA_TO_JWT_NAMES.put(RSA_1_5_ALGO_JAVA, "RSA1_5");
        JAVA_TO_JWT_NAMES.put(AES_GCM_ALGO_JAVA, "A256GCM");
        JAVA_TO_JWT_NAMES.put(AES_GCM_ALGO_JAVA, "A192GCM");
        JAVA_TO_JWT_NAMES.put(AES_GCM_ALGO_JAVA, "A128GCM");
        JAVA_TO_JWT_NAMES.put(AES_WRAP_ALGO_JAVA, "A128KW");
        JAVA_TO_JWT_NAMES.put(AES_WRAP_ALGO_JAVA, "A192KW");
        JAVA_TO_JWT_NAMES.put(AES_WRAP_ALGO_JAVA, "A256KW");
        JAVA_TO_JWT_NAMES.put(AES_CBC_ALGO_JAVA, "A128CBC-HS256");
        JAVA_TO_JWT_NAMES.put(AES_CBC_ALGO_JAVA, "A192CBC-HS384");
        JAVA_TO_JWT_NAMES.put(AES_CBC_ALGO_JAVA, "A256CBC-HS512");
        JWT_TO_JAVA_NAMES = new HashMap<String, String>();
        JWT_TO_JAVA_NAMES.put("HS256", HMAC_SHA_256_JAVA);
        JWT_TO_JAVA_NAMES.put("HS384", HMAC_SHA_384_JAVA);
        JWT_TO_JAVA_NAMES.put("HS512", HMAC_SHA_512_JAVA);
        JWT_TO_JAVA_NAMES.put("RS256", RS_SHA_256_JAVA);
        JWT_TO_JAVA_NAMES.put("RS384", RS_SHA_384_JAVA);
        JWT_TO_JAVA_NAMES.put("RS512", RS_SHA_512_JAVA);
        JWT_TO_JAVA_NAMES.put("PS256", PS_SHA_256_JAVA);
        JWT_TO_JAVA_NAMES.put("PS384", PS_SHA_384_JAVA);
        JWT_TO_JAVA_NAMES.put("PS512", PS_SHA_512_JAVA);
        JWT_TO_JAVA_NAMES.put("ES256", ES_SHA_256_JAVA);
        JWT_TO_JAVA_NAMES.put("ES384", ES_SHA_384_JAVA);
        JWT_TO_JAVA_NAMES.put("ES512", ES_SHA_512_JAVA);
        JWT_TO_JAVA_NAMES.put("RSA-OAEP", RSA_OAEP_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("RSA-OAEP-256", RSA_OAEP_256_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("RSA1_5", RSA_1_5_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("A128KW", AES_WRAP_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("A192KW", AES_WRAP_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("A256KW", AES_WRAP_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("A256GCM", AES_GCM_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("A192GCM", AES_GCM_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("A128GCM", AES_GCM_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("A256GCMKW", AES_GCM_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("A192GCMKW", AES_GCM_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("A128GCMKW", AES_GCM_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("A128CBC-HS256", AES_CBC_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("A192CBC-HS384", AES_CBC_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("A256CBC-HS512", AES_CBC_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("PBES2-HS256+A128KW", AES_WRAP_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("PBES2-HS384+A192KW", AES_WRAP_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("PBES2-HS512+A256KW", AES_WRAP_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("ECDH-ES+A128KW", AES_WRAP_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("ECDH-ES+A192KW", AES_WRAP_ALGO_JAVA);
        JWT_TO_JAVA_NAMES.put("ECDH-ES+A256KW", AES_WRAP_ALGO_JAVA);
    }
}

