/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.crypto.HmacUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jws.AbstractJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;

public class HmacJwsSignatureProvider
extends AbstractJwsSignatureProvider {
    private byte[] key;
    private AlgorithmParameterSpec hmacSpec;

    public HmacJwsSignatureProvider(byte[] key, String algo) {
        this(key, null, algo);
    }

    public HmacJwsSignatureProvider(byte[] key, AlgorithmParameterSpec spec, String algo) {
        super(algo);
        this.key = key;
        this.hmacSpec = spec;
    }

    public HmacJwsSignatureProvider(String encodedKey, String algo) {
        super(algo);
        try {
            this.key = Base64UrlUtility.decode((String)encodedKey);
        }
        catch (Base64Exception ex) {
            throw new SecurityException();
        }
    }

    @Override
    protected JwsSignature doCreateJwsSignature(JoseHeaders headers) {
        final Mac mac = HmacUtils.getInitializedMac((byte[])this.key, (String)Algorithm.toJavaName(headers.getAlgorithm()), (AlgorithmParameterSpec)this.hmacSpec);
        return new JwsSignature(){

            @Override
            public void update(byte[] src, int off, int len) {
                mac.update(src, off, len);
            }

            @Override
            public byte[] sign() {
                return mac.doFinal();
            }
        };
    }

    @Override
    protected void checkAlgorithm(String algo) {
        super.checkAlgorithm(algo);
        if (!Algorithm.isHmacSign(algo)) {
            throw new SecurityException();
        }
    }
}

