/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.interfaces.RSAPublicKey;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsCompactConsumer {
    private JoseHeadersReaderWriter reader = new JoseHeadersReaderWriter();
    private String encodedSequence;
    private String encodedSignature;
    private String headersJson;
    private String decodedJwsPayload;

    public JwsCompactConsumer(String encodedJws) {
        this(encodedJws, null, null);
    }

    public JwsCompactConsumer(String encodedJws, String encodedDetachedPayload) {
        this(encodedJws, encodedDetachedPayload, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JwsCompactConsumer(String encodedJws, String encodedDetachedPayload, JoseHeadersReaderWriter r) {
        String[] parts;
        if (r != null) {
            this.reader = r;
        }
        if (encodedJws.startsWith("\"") && encodedJws.endsWith("\"")) {
            encodedJws = encodedJws.substring(1, encodedJws.length() - 1);
        }
        if ((parts = encodedJws.split("\\.")).length != 3) {
            if (parts.length != 2 || !encodedJws.endsWith(".")) throw new SecurityException("Invalid JWS Compact sequence");
            this.encodedSignature = "";
        } else {
            this.encodedSignature = parts[2];
        }
        String encodedJwsPayload = parts[1];
        if (encodedDetachedPayload != null) {
            if (!StringUtils.isEmpty((String)encodedJwsPayload)) {
                throw new SecurityException("Invalid JWS Compact sequence");
            }
            encodedJwsPayload = encodedDetachedPayload;
        }
        this.encodedSequence = parts[0] + "." + encodedJwsPayload;
        this.headersJson = JoseUtils.decodeToString(parts[0]);
        this.decodedJwsPayload = JoseUtils.decodeToString(encodedJwsPayload);
    }

    public String getUnsignedEncodedSequence() {
        return this.encodedSequence;
    }

    public String getEncodedSignature() {
        return this.encodedSignature;
    }

    public String getDecodedJsonHeaders() {
        return this.headersJson;
    }

    public String getDecodedJwsPayload() {
        return this.decodedJwsPayload;
    }

    public byte[] getDecodedJwsPayloadBytes() {
        return StringUtils.toBytesUTF8((String)this.decodedJwsPayload);
    }

    public byte[] getDecodedSignature() {
        return this.encodedSignature.isEmpty() ? new byte[]{} : JoseUtils.decode(this.encodedSignature);
    }

    public JoseHeaders getJoseHeaders() {
        JoseHeaders joseHeaders = this.reader.fromJsonHeaders(this.headersJson);
        if (joseHeaders.getUpdateCount() != null) {
            throw new SecurityException("Duplicate headers have been detected");
        }
        return joseHeaders;
    }

    public boolean verifySignatureWith(JwsSignatureVerifier validator) {
        try {
            if (validator.verify(this.getJoseHeaders(), this.getUnsignedEncodedSequence(), this.getDecodedSignature())) {
                return true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    public boolean verifySignatureWith(JsonWebKey key) {
        return this.verifySignatureWith(JwsUtils.getSignatureVerifier(key));
    }

    public boolean verifySignatureWith(JsonWebKey key, String algo) {
        return this.verifySignatureWith(JwsUtils.getSignatureVerifier(key, algo));
    }

    public boolean verifySignatureWith(RSAPublicKey key, String algo) {
        return this.verifySignatureWith(JwsUtils.getRSAKeySignatureVerifier(key, algo));
    }

    public boolean verifySignatureWith(byte[] key, String algo) {
        return this.verifySignatureWith(JwsUtils.getHmacSignatureVerifier(key, algo));
    }

    public boolean validateCriticalHeaders() {
        return JwsUtils.validateCriticalHeaders(this.getJoseHeaders());
    }

    protected JoseHeadersReaderWriter getReader() {
        return this.reader;
    }
}

