/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwt;

import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtTokenReaderWriter;

public final class JwtUtils {
    private JwtUtils() {
    }

    public static String claimsToJson(JwtClaims claims) {
        return JwtUtils.claimsToJson(claims, null);
    }

    public static String claimsToJson(JwtClaims claims, JwtTokenReaderWriter writer) {
        if (writer == null) {
            writer = new JwtTokenReaderWriter();
        }
        return writer.claimsToJson(claims);
    }

    public static JwtClaims jsonToClaims(String json) {
        return new JwtTokenReaderWriter().fromJsonClaims(json);
    }

    public static void validateJwtTimeClaims(JwtClaims claims, int issuedAtRange, boolean claimsRequired) {
        Long currentTimeInSecs = System.currentTimeMillis() / 1000L;
        Long expiryTimeInSecs = claims.getExpiryTime();
        if (expiryTimeInSecs == null && claimsRequired || expiryTimeInSecs != null && currentTimeInSecs > expiryTimeInSecs) {
            throw new SecurityException("The token expired");
        }
        Long issuedAtInSecs = claims.getIssuedAt();
        if (issuedAtInSecs == null && claimsRequired || issuedAtInSecs != null && (issuedAtInSecs > currentTimeInSecs || issuedAtRange > 0 && issuedAtInSecs < currentTimeInSecs - (long)issuedAtRange)) {
            throw new SecurityException("Invalid issuedAt");
        }
    }

    public static void validateJwtTimeClaims(JwtClaims claims) {
        JwtUtils.validateJwtTimeClaims(claims, 0, false);
    }
}

