/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.cxf.jaxrs.ext.search.visitor;


/**
 * Simple thread local storage implementation for helping
 * search condition visitors to access its state across multiple
 * visit calls when a given visitor is not created on per-request basis.
 */
public class LocalVisitorState<T> implements VisitorState<T> {
    private T value;
    
    public LocalVisitorState() {
    }
    
    public T get() {
        return value;
    }

    public T remove() {
        T oldValue = get();
        value = null;
        return oldValue;
    }

    public void set(T v) {
        this.value = v;
    }    
}
