/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso.state;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.DiskStoreConfiguration;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.rs.security.saml.sso.EHCacheUtil;
import org.apache.cxf.rs.security.saml.sso.state.RequestState;
import org.apache.cxf.rs.security.saml.sso.state.ResponseState;
import org.apache.cxf.rs.security.saml.sso.state.SPStateManager;

public class EHCacheSPStateManager
implements SPStateManager {
    public static final long DEFAULT_TTL = 300L;
    public static final String REQUEST_CACHE_KEY = "cxf.samlp.request.state.cache";
    public static final String RESPONSE_CACHE_KEY = "cxf.samlp.response.state.cache";
    private static final String DEFAULT_CONFIG_URL = "/cxf-samlp-ehcache.xml";
    private Ehcache requestCache;
    private Ehcache responseCache;
    private CacheManager cacheManager;
    private long ttl = 300L;

    public EHCacheSPStateManager() {
        this(DEFAULT_CONFIG_URL, null);
    }

    public EHCacheSPStateManager(Bus bus) {
        this(DEFAULT_CONFIG_URL, bus);
    }

    public EHCacheSPStateManager(String configFileURL) {
        this(configFileURL, null);
    }

    public EHCacheSPStateManager(String configFileURL, Bus bus) {
        this.createCaches(configFileURL, bus);
    }

    private void createCaches(String configFile, Bus bus) {
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus((boolean)true);
        }
        URL configFileURL = null;
        try {
            configFileURL = ResourceUtils.getClasspathResourceURL((String)configFile, EHCacheSPStateManager.class, (Bus)bus);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (configFileURL == null) {
            this.cacheManager = EHCacheUtil.createCacheManager();
        } else {
            Configuration conf = ConfigurationFactory.parseConfiguration((URL)configFileURL);
            if (bus != null) {
                conf.setName(bus.getId());
                DiskStoreConfiguration dsc = conf.getDiskStoreConfiguration();
                if (dsc != null && "java.io.tmpdir".equals(dsc.getOriginalPath())) {
                    String path = conf.getDiskStoreConfiguration().getPath() + File.separator + bus.getId();
                    conf.getDiskStoreConfiguration().setPath(path);
                }
            }
            this.cacheManager = EHCacheUtil.createCacheManager(conf);
        }
        CacheConfiguration requestCC = EHCacheUtil.getCacheConfiguration(REQUEST_CACHE_KEY, this.cacheManager);
        Cache newCache = new Cache(requestCC);
        this.requestCache = this.cacheManager.addCacheIfAbsent((Ehcache)newCache);
        CacheConfiguration responseCC = EHCacheUtil.getCacheConfiguration(RESPONSE_CACHE_KEY, this.cacheManager);
        newCache = new Cache(responseCC);
        this.responseCache = this.cacheManager.addCacheIfAbsent((Ehcache)newCache);
    }

    public void setTTL(long newTtl) {
        this.ttl = newTtl;
    }

    public long getTTL() {
        return this.ttl;
    }

    @Override
    public ResponseState getResponseState(String securityContextKey) {
        Element element = this.responseCache.get((Serializable)((Object)securityContextKey));
        if (element != null) {
            if (this.responseCache.isExpired(element)) {
                this.responseCache.remove((Serializable)((Object)securityContextKey));
                return null;
            }
            return (ResponseState)element.getObjectValue();
        }
        return null;
    }

    @Override
    public ResponseState removeResponseState(String securityContextKey) {
        Element element = this.responseCache.get((Serializable)((Object)securityContextKey));
        if (element != null) {
            this.responseCache.remove((Serializable)((Object)securityContextKey));
            return (ResponseState)element.getObjectValue();
        }
        return null;
    }

    @Override
    public void setResponseState(String securityContextKey, ResponseState state) {
        if (securityContextKey == null || "".equals(securityContextKey)) {
            return;
        }
        int parsedTTL = (int)this.ttl;
        if (this.ttl != (long)parsedTTL) {
            parsedTTL = 300;
        }
        Element element = new Element((Serializable)((Object)securityContextKey), (Serializable)state);
        element.setTimeToLive(parsedTTL);
        element.setTimeToIdle(parsedTTL);
        this.responseCache.put(element);
    }

    @Override
    public void setRequestState(String relayState, RequestState state) {
        if (relayState == null || "".equals(relayState)) {
            return;
        }
        int parsedTTL = (int)this.ttl;
        if (this.ttl != (long)parsedTTL) {
            parsedTTL = 3600;
        }
        Element element = new Element((Serializable)((Object)relayState), (Serializable)state);
        element.setTimeToLive(parsedTTL);
        element.setTimeToIdle(parsedTTL);
        this.requestCache.put(element);
    }

    @Override
    public RequestState removeRequestState(String relayState) {
        Element element = this.requestCache.get((Serializable)((Object)relayState));
        if (element != null) {
            this.requestCache.remove((Serializable)((Object)relayState));
            return (RequestState)element.getObjectValue();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.cacheManager != null) {
            this.cacheManager.shutdown();
            this.cacheManager = null;
            this.requestCache = null;
            this.responseCache = null;
        }
    }
}

