/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.xml.WSDLWriter;

public abstract class SchemaFactory {
    private static final String PROPERTY_NAME = "javax.wsdl.factory.SchemaFactory";
    private static final String PROPERTY_FILE_NAME = "wsdl.properties";
    private static final String DEFAULT_FACTORY_IMPL_NAME = "org.apache.cxf.tools.corba.processors.wsdl.SchemaFactoryImpl";
    private static String fullPropertyFileName;

    public static SchemaFactory newInstance() throws WSDLException {
        String factoryImplName = SchemaFactory.findFactoryImplName();
        return SchemaFactory.newInstance(factoryImplName);
    }

    public static SchemaFactory newInstance(String factoryImplName) throws WSDLException {
        if (factoryImplName != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> cl = loader.loadClass(factoryImplName);
                return (SchemaFactory)cl.newInstance();
            }
            catch (Exception e) {
                throw new WSDLException("CONFIGURATION_ERROR", "Problem instantiating factory implementation.", (Throwable)e);
            }
        }
        throw new WSDLException("CONFIGURATION_ERROR", "Unable to find name of factory implementation.");
    }

    public abstract WSDLWriter newWSDLWriter();

    public abstract ExtensionRegistry newPopulatedExtensionRegistry();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findFactoryImplName() {
        String factoryImplName = null;
        try {
            factoryImplName = System.getProperty(PROPERTY_NAME);
            if (factoryImplName != null) {
                return factoryImplName;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        String propFileName = SchemaFactory.getFullPropertyFileName();
        if (propFileName != null) {
            try {
                Properties properties = new Properties();
                File propFile = new File(propFileName);
                try (FileInputStream fis = null;){
                    fis = new FileInputStream(propFile);
                    properties.load(fis);
                }
                factoryImplName = properties.getProperty(PROPERTY_NAME);
                if (factoryImplName != null) {
                    return factoryImplName;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return DEFAULT_FACTORY_IMPL_NAME;
    }

    private static String getFullPropertyFileName() {
        if (fullPropertyFileName == null) {
            try {
                String javaHome = System.getProperty("java.home");
                fullPropertyFileName = javaHome + File.separator + "lib" + File.separator + PROPERTY_FILE_NAME;
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        return fullPropertyFileName;
    }
}

