/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.AddressType;
import org.apache.cxf.binding.corba.wsdl.CorbaConstants;
import org.apache.cxf.binding.corba.wsdl.CorbaType;
import org.apache.cxf.binding.corba.wsdl.TypeMappingType;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.corba.processors.idl.IDLProcessor;
import org.apache.cxf.tools.corba.processors.idl.ModuleToNSMapper;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.cxf.tools.corba.processors.idl.WSDLSchemaManager;
import org.apache.cxf.tools.util.FileWriterUtil;
import org.apache.ws.commons.schema.XmlSchema;

public class IDLToWSDLProcessor
extends IDLProcessor {
    private String idl;
    private String schemaFilename;
    private String importSchemaFilename;
    private String logical;
    private String physical;
    private String outputDir;
    private Writer outputWriter;
    private Writer schemaOutputWriter;
    private Writer logicalOutputWriter;
    private Writer physicalOutputWriter;
    private Map<String, File> importDefnWriters;
    private Map<String, File> importSchemaWriters;
    private boolean ignoreImports;

    @Override
    public void process() throws ToolException {
        super.process();
        this.process(this.getIDLTree());
    }

    public void process(AST idlTree) throws ToolException {
        this.idl = this.getBaseFilename(this.env.get("idl").toString());
        this.checkFileOptions();
        try {
            this.parseIDL(idlTree);
        }
        catch (Exception e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void setOutputWriter(Writer writer) {
        this.outputWriter = writer;
    }

    public void setSchemaOutputWriter(Writer writer) {
        this.schemaOutputWriter = writer;
    }

    public void setLogicalOutputWriter(Writer writer) {
        this.logicalOutputWriter = writer;
    }

    public void setPhysicalOutputWriter(Writer writer) {
        this.physicalOutputWriter = writer;
    }

    protected void setImportDefinitionWriters(Map<String, File> writers) {
        this.importDefnWriters = writers;
    }

    protected void setImportSchemaWriters(Map<String, File> writers) {
        this.importSchemaWriters = writers;
    }

    protected void setIgnoreImports(boolean flag) {
        this.ignoreImports = flag;
    }

    private void checkFileOptions() {
        if (this.env.optionSet("logical")) {
            this.logical = this.env.get("logical").toString();
        }
        if (this.env.optionSet("physical")) {
            this.physical = this.env.get("physical").toString();
        }
        if (this.env.optionSet("schema")) {
            this.schemaFilename = this.env.get("schema").toString();
        }
        if (this.env.optionSet("importschema")) {
            this.importSchemaFilename = this.env.get("importschema").toString();
        }
    }

    public void parseIDL(AST idlTree) throws Exception {
        String tns;
        if (this.env.isVerbose()) {
            System.out.println(idlTree.toStringTree());
        }
        if ((tns = (String)this.env.get("tns")) == null) {
            tns = "http://cxf.apache.org/bindings/corba/idl/" + this.idl;
        }
        String schemans = (String)this.env.get("schemans");
        String corbatypemaptns = (String)this.env.get("corbatypemapns");
        this.outputDir = ".";
        try {
            WSDLASTVisitor visitor = new WSDLASTVisitor(tns, schemans, corbatypemaptns, this.preprocessor.getPragmaPrefix());
            visitor.getManager().setIgnoreImports(this.ignoreImports);
            if (this.env.optionSet("outputdir")) {
                this.outputDir = (String)this.env.get("outputdir");
            }
            visitor.setOutputDir(this.outputDir);
            Definition def = visitor.getDefinition();
            if (this.env.optionSet("sequencetype")) {
                visitor.setSequenceOctetType((String)this.env.get("sequencetype"));
            }
            if (this.env.optionSet("schemans")) {
                def.addNamespace("xsd1", (String)this.env.get("schemans"));
            }
            if (this.env.optionSet("boundedstrings")) {
                visitor.setBoundedStringOverride(true);
            }
            if (this.env.optionSet("moduletonamespace")) {
                String mapping = (String)this.env.get("moduletonamespace");
                visitor.setModuleToNSMapping(this.getModuleToNSMapping(mapping));
            }
            if (this.env.optionSet("qualified")) {
                visitor.setQualified(true);
            }
            if (this.env.optionSet("polymorphicfactories")) {
                visitor.setSupportPolymorphicFactories(true);
            }
            if (this.env.optionSet("schema")) {
                visitor.setSchemaGenerated(true);
                if (this.env.get("schemans") == null) {
                    visitor.updateSchemaNamespace(def.getTargetNamespace() + "-types");
                    def.addNamespace("xsd1", def.getTargetNamespace() + "-types");
                }
            }
            if (this.env.optionSet("excludemodules")) {
                String modules = (String)this.env.get("excludemodules");
                visitor.setExcludedModules(this.getExcludedModules(modules));
            }
            visitor.visit(idlTree);
            this.cleanUpTypeMap(visitor.getTypeMap());
            Binding[] bindings = visitor.getCorbaBindings();
            this.generateCORBAService(def, bindings, visitor.getModuleToNSMapper().isDefaultMapping());
            this.writeDefinitions(visitor);
        }
        catch (Exception ex) {
            throw new ToolException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void writeDefinitions(WSDLASTVisitor visitor) throws Exception {
        if (this.env.optionSet("logical") || this.env.optionSet("physical") || this.env.optionSet("schema") || this.env.optionSet("importschema")) {
            if (this.logical == null || this.physical == null) {
                if (this.outputWriter == null) {
                    this.outputWriter = this.getOutputWriter(this.idl + ".wsdl", this.outputDir);
                }
                String separator = System.getProperty("file.separator");
                File file = null;
                file = this.env.get("outputdir") != null ? new File(this.outputDir + separator + this.idl + ".wsdl") : new File(this.idl + ".wsdl");
                visitor.setIdlFile(file.getAbsolutePath());
            }
            if (this.logical != null) {
                this.logical = this.getFilePath(this.logical).getAbsolutePath();
                if (this.logicalOutputWriter == null) {
                    this.logicalOutputWriter = this.createOutputWriter(this.logical);
                }
            }
            if (this.physical != null) {
                this.physical = this.getFilePath(this.physical).getAbsolutePath();
                if (this.physicalOutputWriter == null) {
                    this.physicalOutputWriter = this.createOutputWriter(this.physical);
                }
            }
            if (this.schemaFilename != null) {
                this.schemaFilename = this.getFilePath(this.schemaFilename).getAbsolutePath();
                if (this.schemaOutputWriter == null) {
                    this.schemaOutputWriter = this.createOutputWriter(this.schemaFilename);
                }
            }
            if (this.importSchemaFilename != null) {
                this.importSchemaFilename = this.getImportFile(this.importSchemaFilename);
                visitor.setImportSchema(this.importSchemaFilename);
            }
            visitor.writeDefinitions(this.outputWriter, this.schemaOutputWriter, this.logicalOutputWriter, this.physicalOutputWriter, this.schemaFilename, this.logical, this.physical);
        } else {
            if (this.outputWriter == null) {
                String outputFile = this.idl + ".wsdl";
                if (this.env.optionSet("wsdloutputfile") && !(outputFile = (String)this.env.get("wsdloutputfile")).endsWith(".wsdl")) {
                    outputFile = outputFile + ".wsdl";
                }
                this.outputWriter = this.getOutputWriter(outputFile, this.outputDir);
            }
            Definition defn = visitor.getDefinition();
            if (!visitor.getModuleToNSMapper().isDefaultMapping()) {
                this.addTypeMapSchemaImports(defn, visitor);
                visitor.getManager().attachDeferredSchemasToWSDL();
            }
            visitor.writeDefinition(defn, this.outputWriter);
            this.writeImportedDefinitionsAndSchemas(visitor);
        }
    }

    private void writeImportedDefinitionsAndSchemas(WSDLASTVisitor visitor) throws Exception {
        Writer writer;
        Map<File, Definition> defns = visitor.getManager().getImportedWSDLDefinitions();
        Map<File, XmlSchema> schemas = visitor.getManager().getImportedXmlSchemas();
        if (this.importDefnWriters != null) assert (this.importDefnWriters.size() == defns.size());
        if (this.importSchemaWriters != null) assert (this.importSchemaWriters.size() == schemas.size());
        for (File file : defns.keySet()) {
            Definition defn = defns.get(file);
            writer = null;
            if (this.importDefnWriters != null) {
                writer = this.getOutputWriter(this.importDefnWriters.get(defn.getTargetNamespace()));
            }
            if (writer == null) {
                writer = this.getOutputWriter(file);
            }
            visitor.writeDefinition(defn, writer);
            writer.close();
        }
        for (File file : schemas.keySet()) {
            XmlSchema schema = schemas.get(file);
            writer = null;
            if (this.importSchemaWriters != null) {
                writer = this.getOutputWriter(this.importSchemaWriters.get(schema.getTargetNamespace()));
            }
            if (writer == null) {
                writer = this.getOutputWriter(file);
            }
            visitor.writeSchema(schema, writer);
            writer.close();
        }
    }

    private String getImportFile(String importFilename) {
        File file = new File(importFilename);
        if (!file.exists()) {
            if (!file.isAbsolute()) {
                String separator = System.getProperty("file.separator");
                String userdir = System.getProperty("user.dir");
                file = new File(userdir + separator + importFilename);
            }
            if (file.exists()) {
                URI url = file.toURI();
                return url.toString();
            }
        } else {
            URI url = file.toURI();
            return url.toString();
        }
        String msg = importFilename + " File not found";
        FileNotFoundException ex = new FileNotFoundException(msg);
        System.err.println("IDLToWsdl Error : " + ex.getMessage());
        System.err.println();
        ex.printStackTrace();
        System.exit(1);
        return null;
    }

    private Writer createOutputWriter(String name) throws Exception {
        String outDir = this.outputDir;
        int index = name.lastIndexOf(System.getProperty("file.separator"));
        outDir = name.substring(0, index);
        String filename = name.substring(index + 1, name.length());
        return this.getOutputWriter(filename, outDir);
    }

    private File getFilePath(String ifile) {
        String separator = System.getProperty("file.separator");
        StringTokenizer token = new StringTokenizer(ifile, separator);
        if (token.countTokens() == 1) {
            if (this.env.get("outputdir") != null) {
                return new File(this.outputDir + separator + ifile);
            }
            return new File(ifile);
        }
        return new File(ifile);
    }

    public Writer getOutputWriter(String filename, String outputDirectory) throws Exception {
        if (this.env.optionSet("encoding")) {
            String encoding = this.env.get("encoding").toString();
            return new FileWriterUtil().getWriter(new File(outputDirectory, filename), encoding);
        }
        FileWriterUtil fw = new FileWriterUtil(outputDirectory, null);
        return fw.getWriter("", filename);
    }

    public Writer getOutputWriter(File file) throws Exception {
        if (this.env.optionSet("encoding")) {
            String encoding = this.env.get("encoding").toString();
            return new FileWriterUtil().getWriter(file, encoding);
        }
        return new FileWriterUtil().getWriter(file, "UTF-8");
    }

    public String getBaseFilename(String ifile) {
        String fileName = ifile;
        StringTokenizer token = new StringTokenizer(ifile, "\\/");
        while (token.hasMoreTokens()) {
            fileName = token.nextToken();
        }
        if (fileName.endsWith(".idl")) {
            fileName = new String(fileName.substring(0, fileName.length() - 4));
        }
        return fileName;
    }

    private Map<String, String> getServiceNames(Binding[] bindings, boolean isDefaultMapping) {
        HashMap<String, String> serviceNames = new HashMap<String, String>();
        for (int i = 0; i < bindings.length; ++i) {
            QName portTypeName = bindings[i].getPortType().getQName();
            String ns = portTypeName.getNamespaceURI();
            if (isDefaultMapping || serviceNames.containsKey(ns)) continue;
            String[] bindingTokens = bindings[i].getQName().getLocalPart().split("\\.");
            if (bindingTokens.length > 1) {
                StringBuilder name = new StringBuilder("");
                for (int j = 0; j < bindingTokens.length - 2; ++j) {
                    name.append(bindingTokens[j] + ".");
                }
                name.append(bindingTokens[bindingTokens.length - 2] + "CORBAService");
                serviceNames.put(ns, name.toString());
                continue;
            }
            serviceNames.put(ns, this.idl + "CORBAService");
        }
        return serviceNames;
    }

    public void generateCORBAService(Definition def, Binding[] bindings, boolean isDefaultMapping) throws Exception {
        HashMap<String, Service> serviceMap = new HashMap<String, Service>();
        Map<String, String> serviceNames = this.getServiceNames(bindings, isDefaultMapping);
        for (int i = 0; i < bindings.length; ++i) {
            Service service;
            QName portTypeName = bindings[i].getPortType().getQName();
            if (isDefaultMapping) {
                service = def.createService();
                service.setQName(new QName(def.getTargetNamespace(), portTypeName.getLocalPart() + "CORBAService"));
                def.addService(service);
            } else {
                String ns = portTypeName.getNamespaceURI();
                String serviceName = serviceNames.get(ns);
                service = (Service)serviceMap.get(ns);
                if (service == null) {
                    service = def.createService();
                    serviceMap.put(ns, service);
                    String[] serviceTokens = serviceName.split("\\.");
                    String serviceToken = serviceTokens[serviceTokens.length - 1];
                    QName serviceQName = new QName(def.getTargetNamespace(), serviceToken);
                    Service existingService = def.getService(serviceQName);
                    if (existingService != null) {
                        String existingServiceNS = ((Port)existingService.getPorts().values().iterator().next()).getBinding().getPortType().getQName().getNamespaceURI();
                        existingService.setQName(new QName(def.getTargetNamespace(), serviceNames.get(existingServiceNS)));
                        serviceMap.put(existingServiceNS, existingService);
                        service.setQName(new QName(def.getTargetNamespace(), serviceName));
                    } else {
                        service.setQName(serviceQName);
                    }
                    def.addService(service);
                }
            }
            Port port = def.createPort();
            port.setName(portTypeName.getLocalPart() + "CORBAPort");
            AddressType address = (AddressType)def.getExtensionRegistry().createExtension(Port.class, CorbaConstants.NE_CORBA_ADDRESS);
            String addr = null;
            String addrFileName = (String)this.env.get("addressfile");
            if (addrFileName != null) {
                try (BufferedReader bufferedReader = null;){
                    File addrFile = new File(addrFileName);
                    FileReader fileReader = new FileReader(addrFile);
                    bufferedReader = new BufferedReader(fileReader);
                    addr = bufferedReader.readLine();
                }
            } else {
                addr = (String)this.env.get("address");
            }
            if (addr == null) {
                addr = "IOR:";
            }
            address.setLocation(addr);
            port.addExtensibilityElement((ExtensibilityElement)address);
            service.addPort(port);
            port.setBinding(bindings[i]);
        }
    }

    public void cleanUpTypeMap(TypeMappingType typeMap) {
        List types = typeMap.getStructOrExceptionOrUnion();
        if (types != null) {
            for (int i = 0; i < types.size(); ++i) {
                CorbaType type = (CorbaType)types.get(i);
                if (type.getQName() == null) continue;
                type.setName(type.getQName().getLocalPart());
                type.setQName(null);
            }
        }
    }

    public void addTypeMapSchemaImports(Definition def, WSDLASTVisitor visitor) {
        List types = visitor.getTypeMap().getStructOrExceptionOrUnion();
        ModuleToNSMapper mapper = visitor.getModuleToNSMapper();
        WSDLSchemaManager manager = visitor.getManager();
        Collection namespaces = CastUtils.cast(def.getNamespaces().values());
        Set<Map.Entry<String, String>> userModuleMappings = mapper.getUserMapping().entrySet();
        if (types != null) {
            for (int i = 0; i < types.size(); ++i) {
                CorbaType type = (CorbaType)types.get(i);
                QName schemaType = type.getType();
                if (schemaType == null) continue;
                String typeNamespace = schemaType.getNamespaceURI();
                try {
                    if (!namespaces.contains(typeNamespace) && typeNamespace.equals("http://www.w3.org/2005/08/addressing")) {
                        Schema wsdlSchema = (Schema)def.getExtensionRegistry().createExtension(Types.class, new QName("http://www.w3.org/2001/XMLSchema", "schema"));
                        SchemaImport schemaimport = wsdlSchema.createImport();
                        schemaimport.setNamespaceURI("http://www.w3.org/2005/08/addressing");
                        schemaimport.setSchemaLocationURI("http://www.w3.org/2005/08/addressing/ws-addr.xsd");
                        wsdlSchema.addImport(schemaimport);
                        def.getTypes().addExtensibilityElement((ExtensibilityElement)wsdlSchema);
                        CastUtils.cast((Map)def.getNamespaces(), String.class, String.class).put("wsa", typeNamespace);
                        continue;
                    }
                    if (namespaces.contains(typeNamespace)) continue;
                    String prefix = this.getModulePrefixForNamespace(userModuleMappings, mapper, typeNamespace);
                    XmlSchema schema = manager.getXmlSchema(typeNamespace);
                    String importFile = visitor.getOutputDir() + System.getProperty("file.separator") + prefix + ".xsd";
                    manager.addWSDLSchemaImport(def, typeNamespace, importFile);
                    manager.getImportedXmlSchemas().put(new File(importFile), schema);
                    CastUtils.cast((Map)def.getNamespaces(), String.class, String.class).put(prefix, typeNamespace);
                    continue;
                }
                catch (Exception ex) {
                    throw new ToolException("Unable to add schema import for namespace" + typeNamespace);
                }
            }
        }
    }

    private String getModulePrefixForNamespace(Set<Map.Entry<String, String>> map, ModuleToNSMapper mapper, String namespace) {
        String prefix = null;
        for (Map.Entry<String, String> entry : map) {
            if (!entry.getValue().equals(namespace)) continue;
            prefix = entry.getKey().replace("::", "_");
            break;
        }
        if (prefix == null) {
            prefix = mapper.mapNSToPrefix(namespace);
        }
        return prefix;
    }

    private Map<String, String> getModuleToNSMapping(String mapping) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (mapping != null && mapping.length() > 0) {
            if (mapping.startsWith("[") && mapping.endsWith("]")) {
                mapping = mapping.substring(1, mapping.length() - 1);
                StringTokenizer tokens = new StringTokenizer(mapping, ",;");
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    int pos = token.indexOf("=");
                    if (pos == -1) {
                        throw new RuntimeException("Mapping of idl modules to namespaces is not specified correctly.Missing a equals(=) sign for specifying the custom mapping.(" + token + ")");
                    }
                    map.put(token.substring(0, pos), token.substring(pos + 1));
                }
            } else if (mapping.startsWith(":")) {
                mapping = mapping.substring(1);
                try (BufferedReader reader = null;){
                    reader = new BufferedReader(new FileReader(mapping));
                    String token = reader.readLine();
                    while (token != null) {
                        int pos = token.indexOf("=");
                        if (pos == -1) {
                            reader.close();
                            throw new RuntimeException("Mapping of idl modules to namespaces is not specified correctly in the file " + mapping + "." + "Missing a equals(=) sign for specifying " + "the custom mapping." + "(" + token + ")");
                        }
                        map.put(token.substring(0, pos), token.substring(pos + 1));
                        token = reader.readLine();
                    }
                }
            } else {
                throw new RuntimeException("Option mns should have a start([) & close(]) bracket or a properties file to customize the mapping of modules to namespaces");
            }
        }
        return map;
    }

    private Map<String, List<String>> getExcludedModules(String modules) {
        HashMap<String, List<String>> exModules = new HashMap<String, List<String>>();
        if (modules != null && modules.length() > 0) {
            if (modules.startsWith("[") && modules.endsWith("]")) {
                modules = modules.substring(1, modules.length() - 1);
                StringTokenizer tokens = new StringTokenizer(modules, ",;");
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    exModules.put(token, new ArrayList());
                }
            } else if (!modules.startsWith(":")) {
                throw new RuntimeException("Option ex should have a start([) & close(]) bracket or a properties file to specify the exclusion of modules");
            }
        }
        return exModules;
    }
}

