/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.security.Principal;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.interceptor.security.RolePrefixSecurityContextImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.rt.security.saml.SAMLSecurityContext;
import org.apache.cxf.rt.security.saml.SAMLUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.stax.securityEvent.KerberosTokenSecurityEvent;
import org.apache.wss4j.stax.securityEvent.KeyValueTokenSecurityEvent;
import org.apache.wss4j.stax.securityEvent.SamlTokenSecurityEvent;
import org.apache.wss4j.stax.securityEvent.UsernameTokenSecurityEvent;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.wss4j.stax.securityEvent.X509TokenSecurityEvent;
import org.apache.wss4j.stax.securityToken.SamlSecurityToken;
import org.apache.wss4j.stax.securityToken.SubjectAndPrincipalSecurityToken;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityToken.SecurityTokenConstants;

public class StaxSecurityContextInInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    public static final String SAML_ROLE_ATTRIBUTENAME_DEFAULT = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role";

    public StaxSecurityContextInInterceptor() {
        super("pre-protocol");
    }

    public void handleMessage(SoapMessage soapMessage) throws Fault {
        List incomingSecurityEventList = (List)soapMessage.get((Object)(SecurityEvent.class.getName() + ".in"));
        if (incomingSecurityEventList != null) {
            try {
                this.doResults(soapMessage, incomingSecurityEventList);
            }
            catch (WSSecurityException e) {
                throw this.createSoapFault(soapMessage.getVersion(), e);
            }
        }
    }

    private void doResults(SoapMessage msg, List<SecurityEvent> incomingSecurityEventList) throws WSSecurityException {
        for (SecurityEvent event : incomingSecurityEventList) {
            SubjectAndPrincipalSecurityToken token = null;
            try {
                token = this.getSubjectPrincipalToken(event);
            }
            catch (XMLSecurityException xMLSecurityException) {
                // empty catch block
            }
            if (token == null) continue;
            Principal p = token.getPrincipal();
            Subject subject = token.getSubject();
            if (subject != null) {
                String roleClassifier = (String)msg.getContextualProperty("ws-security.role.classifier");
                if (roleClassifier != null && !"".equals(roleClassifier)) {
                    String roleClassifierType = (String)msg.getContextualProperty("ws-security.role.classifier.type");
                    if (roleClassifierType == null || "".equals(roleClassifierType)) {
                        roleClassifierType = "prefix";
                    }
                    msg.put(SecurityContext.class, (Object)new RolePrefixSecurityContextImpl(subject, roleClassifier, roleClassifierType));
                    break;
                }
                msg.put(SecurityContext.class, (Object)new DefaultSecurityContext(subject));
                break;
            }
            if (p == null) continue;
            SamlAssertionWrapper receivedAssertion = null;
            if (event.getSecurityEventType() == WSSecurityEventConstants.SamlToken) {
                SamlTokenSecurityEvent samlEvent;
                String roleAttributeName = (String)msg.getContextualProperty("ws-security.saml-role-attributename");
                if (roleAttributeName == null || roleAttributeName.length() == 0) {
                    roleAttributeName = SAML_ROLE_ATTRIBUTENAME_DEFAULT;
                }
                if ((receivedAssertion = (samlEvent = (SamlTokenSecurityEvent)event).getSamlAssertionWrapper()) == null) break;
                ClaimCollection claims = SAMLUtils.getClaims((SamlAssertionWrapper)receivedAssertion);
                Set roles = SAMLUtils.parseRolesFromClaims((ClaimCollection)claims, (String)roleAttributeName, null);
                SAMLSecurityContext context = new SAMLSecurityContext(p, roles, claims);
                msg.put(SecurityContext.class, (Object)context);
                break;
            }
            msg.put(SecurityContext.class, (Object)this.createSecurityContext(p));
            break;
        }
    }

    private SubjectAndPrincipalSecurityToken getSubjectPrincipalToken(SecurityEvent event) throws XMLSecurityException {
        if (event.getSecurityEventType() == WSSecurityEventConstants.UsernameToken) {
            return (SubjectAndPrincipalSecurityToken)((UsernameTokenSecurityEvent)event).getSecurityToken();
        }
        if (event.getSecurityEventType() == WSSecurityEventConstants.SamlToken && this.isSamlEventSigned((SamlTokenSecurityEvent)event)) {
            return (SubjectAndPrincipalSecurityToken)((SamlTokenSecurityEvent)event).getSecurityToken();
        }
        if (event.getSecurityEventType() == WSSecurityEventConstants.X509Token && this.isUsedForPublicKeySignature((SubjectAndPrincipalSecurityToken)((X509TokenSecurityEvent)event).getSecurityToken())) {
            return (SubjectAndPrincipalSecurityToken)((X509TokenSecurityEvent)event).getSecurityToken();
        }
        if (event.getSecurityEventType() == WSSecurityEventConstants.KeyValueToken && this.isUsedForPublicKeySignature((SubjectAndPrincipalSecurityToken)((KeyValueTokenSecurityEvent)event).getSecurityToken())) {
            return (SubjectAndPrincipalSecurityToken)((KeyValueTokenSecurityEvent)event).getSecurityToken();
        }
        if (event.getSecurityEventType() == WSSecurityEventConstants.KerberosToken) {
            return (SubjectAndPrincipalSecurityToken)((KerberosTokenSecurityEvent)event).getSecurityToken();
        }
        return null;
    }

    private boolean isUsedForPublicKeySignature(SubjectAndPrincipalSecurityToken token) throws XMLSecurityException {
        if (token == null) {
            return false;
        }
        List tokenUsages = token.getTokenUsages();
        boolean usedForSignature = false;
        if (tokenUsages != null) {
            for (SecurityTokenConstants.TokenUsage usage : tokenUsages) {
                if (!"MainSignature".equals(usage.getName())) continue;
                usedForSignature = true;
                break;
            }
        }
        if (!usedForSignature) {
            return false;
        }
        return token.getPublicKey() != null || token.getX509Certificates() != null && token.getX509Certificates().length > 0;
    }

    private boolean isSamlEventSigned(SamlTokenSecurityEvent event) {
        if (event == null) {
            return false;
        }
        return event.getSecurityToken() != null && ((SamlSecurityToken)event.getSecurityToken()).getSamlAssertionWrapper() != null && ((SamlSecurityToken)event.getSecurityToken()).getSamlAssertionWrapper().isSigned();
    }

    private SecurityContext createSecurityContext(final Principal p) {
        return new SecurityContext(){

            public Principal getUserPrincipal() {
                return p;
            }

            public boolean isUserInRole(String arg0) {
                return false;
            }
        };
    }

    private SoapFault createSoapFault(SoapVersion version, WSSecurityException e) {
        SoapFault fault;
        QName faultCode = e.getFaultCode();
        if (version.getVersion() == 1.1 && faultCode != null) {
            fault = new SoapFault(e.getMessage(), (Throwable)e, faultCode);
        } else {
            fault = new SoapFault(e.getMessage(), (Throwable)e, version.getSender());
            if (version.getVersion() != 1.1 && faultCode != null) {
                fault.setSubCode(faultCode);
            }
        }
        return fault;
    }
}

