/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.realm;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.sts.SignatureProperties;
import org.apache.cxf.sts.StaticSTSProperties;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;

public class SAMLRealm {
    private static final Logger LOG = LogUtils.getL7dLogger(SAMLRealm.class);
    private String issuer;
    private String signatureAlias;
    private Crypto signatureCrypto;
    private SignatureProperties signatureProperties;
    private String signaturePropertiesFile;
    private String callbackHandlerClass;
    private CallbackHandler callbackHandler;

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getSignatureAlias() {
        return this.signatureAlias;
    }

    public void setSignatureAlias(String signatureAlias) {
        this.signatureAlias = signatureAlias;
    }

    public void setSignatureCrypto(Crypto signatureCrypto) {
        this.signatureCrypto = signatureCrypto;
    }

    public void setSignaturePropertiesFile(String signaturePropertiesFile) {
        this.signaturePropertiesFile = signaturePropertiesFile;
        LOG.fine("Setting signature properties: " + signaturePropertiesFile);
    }

    public void setSignatureProperties(SignatureProperties signatureProperties) {
        this.signatureProperties = signatureProperties;
    }

    public SignatureProperties getSignatureProperties() {
        return this.signatureProperties;
    }

    public Crypto getSignatureCrypto() {
        if (this.signatureCrypto == null && this.signaturePropertiesFile != null) {
            Properties sigProperties = SAMLRealm.getProps(this.signaturePropertiesFile);
            if (sigProperties == null) {
                LOG.fine("Cannot load signature properties using: " + this.signaturePropertiesFile);
                throw new STSException("Configuration error: cannot load signature properties");
            }
            try {
                this.signatureCrypto = CryptoFactory.getInstance((Properties)sigProperties);
            }
            catch (WSSecurityException ex) {
                LOG.fine("Error in loading the signature Crypto object: " + ex.getMessage());
                throw new STSException(ex.getMessage());
            }
        }
        return this.signatureCrypto;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
        LOG.fine("Setting callbackHandler: " + callbackHandler);
    }

    public void setCallbackHandlerClass(String callbackHandlerClass) {
        this.callbackHandlerClass = callbackHandlerClass;
        LOG.fine("Setting callbackHandlerClass: " + callbackHandlerClass);
    }

    public CallbackHandler getCallbackHandler() {
        if (this.callbackHandler == null && this.callbackHandlerClass != null) {
            this.callbackHandler = this.getCallbackHandler(this.callbackHandlerClass);
            if (this.callbackHandler == null) {
                LOG.fine("Cannot load CallbackHandler using: " + this.callbackHandlerClass);
                throw new STSException("Configuration error: cannot load callback handler");
            }
        }
        return this.callbackHandler;
    }

    private static Properties getProps(Object o) {
        Properties properties = null;
        if (o instanceof Properties) {
            properties = (Properties)o;
        } else if (o instanceof String) {
            URL url = null;
            Bus bus = PhaseInterceptorChain.getCurrentMessage().getExchange().getBus();
            ResourceManager rm = (ResourceManager)bus.getExtension(ResourceManager.class);
            url = (URL)rm.resolveResource((String)o, URL.class);
            try {
                if (url == null) {
                    url = ClassLoaderUtils.getResource((String)((String)o), StaticSTSProperties.class);
                }
                if (url == null) {
                    url = new URL((String)o);
                }
                if (url != null) {
                    properties = new Properties();
                    InputStream ins = url.openStream();
                    properties.load(ins);
                    ins.close();
                }
            }
            catch (IOException e) {
                LOG.fine(e.getMessage());
                properties = null;
            }
        } else if (o instanceof URL) {
            properties = new Properties();
            try {
                InputStream ins = ((URL)o).openStream();
                properties.load(ins);
                ins.close();
            }
            catch (IOException e) {
                LOG.fine(e.getMessage());
                properties = null;
            }
        }
        return properties;
    }

    private CallbackHandler getCallbackHandler(Object o) {
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), this.getClass()).newInstance();
            }
            catch (Exception e) {
                LOG.fine(e.getMessage());
                handler = null;
            }
        }
        return handler;
    }
}

