/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose;

import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.List;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;

public final class JoseUtils {
    private JoseUtils() {
    }

    public static void setJoseContextProperty(JoseHeaders headers) {
        String context = (String)JAXRSUtils.getCurrentMessage().get((Object)"org.apache.cxf.jose.context");
        if (context != null) {
            headers.setHeader("org.apache.cxf.jose.context", context);
        }
    }

    public static void setJoseMessageContextProperty(JoseHeaders headers, String value) {
        headers.setHeader("org.apache.cxf.jose.context", value);
        JAXRSUtils.getCurrentMessage().put((Object)"org.apache.cxf.jose.context", (Object)value);
    }

    public static void setMessageContextProperty(JoseHeaders headers) {
        String context = (String)headers.getHeader("org.apache.cxf.jose.context");
        if (context != null) {
            JAXRSUtils.getCurrentMessage().put((Object)"org.apache.cxf.jose.context", (Object)context);
        }
    }

    public static void validateRequestContextProperty(JoseHeaders headers) {
        Object requestContext = JAXRSUtils.getCurrentMessage().get((Object)"org.apache.cxf.jose.context");
        Object headerContext = headers.getHeader("org.apache.cxf.jose.context");
        if (requestContext == null && headerContext == null) {
            return;
        }
        if (requestContext == null && headerContext != null || requestContext != null && headerContext == null || !requestContext.equals(headerContext)) {
            throw new SecurityException();
        }
    }

    public static String checkContentType(String contentType, String defaultType) {
        if (contentType != null) {
            String typeWithoutParams;
            int paramIndex = contentType.indexOf(59);
            String string = typeWithoutParams = paramIndex == -1 ? contentType : contentType.substring(0, paramIndex);
            if (typeWithoutParams.indexOf(47) == -1) {
                contentType = "application/" + contentType;
            }
        } else {
            contentType = defaultType;
        }
        return contentType;
    }

    public static String expandContentType(String contentType) {
        String typeWithoutParams;
        int paramIndex = contentType.indexOf(59);
        String string = typeWithoutParams = paramIndex == -1 ? contentType : contentType.substring(0, paramIndex);
        if (typeWithoutParams.indexOf(47) == -1) {
            contentType = "application/" + contentType;
        }
        return contentType;
    }

    public static String decodeToString(String encoded) {
        try {
            return new String(JoseUtils.decode(encoded), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new SecurityException(ex);
        }
    }

    public static byte[] decode(String encoded) {
        return CryptoUtils.decodeSequence((String)encoded);
    }

    public static boolean validateCriticalHeaders(JoseHeaders headers) {
        List<String> critical = headers.getCritical();
        if (critical == null) {
            return true;
        }
        if (critical.isEmpty() || JoseUtils.detectDoubleEntry(critical) || critical.contains("crit")) {
            return false;
        }
        return headers.asMap().keySet().containsAll(critical);
    }

    private static boolean detectDoubleEntry(List<?> list) {
        HashSet inputSet = new HashSet(list);
        return list.size() > inputSet.size();
    }
}

