/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJwsJsonReaderProvider;
import org.apache.cxf.rs.security.jose.jws.JwsJsonConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsJsonSignatureEntry;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;

@PreMatching
@Priority(value=1002)
public class JwsJsonContainerRequestFilter
extends AbstractJwsJsonReaderProvider
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext context) throws IOException {
        if ("GET".equals(context.getMethod())) {
            return;
        }
        List<JwsSignatureVerifier> theSigVerifiers = this.getInitializedSigVerifiers();
        JwsJsonConsumer p = new JwsJsonConsumer(IOUtils.readStringFromStream((InputStream)context.getEntityStream()));
        if (this.isStrictVerification() && p.getSignatureEntries().size() != theSigVerifiers.size() || !p.verifySignatureWith(theSigVerifiers)) {
            context.abortWith(JAXRSUtils.toResponse((int)400));
            return;
        }
        byte[] bytes = p.getDecodedJwsPayloadBytes();
        context.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
        context.getHeaders().putSingle((Object)"Content-Length", (Object)Integer.toString(bytes.length));
        JwsJsonSignatureEntry sigEntry = p.getSignatureEntries().get(0);
        String ct = JoseUtils.checkContentType(sigEntry.getUnionHeader().getContentType(), this.getDefaultMediaType());
        if (ct != null) {
            context.getHeaders().putSingle((Object)"Content-Type", (Object)ct);
        }
    }
}

