/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.rs.security.jose.jwe.AbstractContentEncryptionCipherProperties;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;

public abstract class AbstractContentEncryptionAlgorithm
extends AbstractContentEncryptionCipherProperties
implements ContentEncryptionAlgorithm {
    private static final int DEFAULT_IV_SIZE = 128;
    private byte[] cek;
    private byte[] iv;
    private AtomicInteger providedIvUsageCount;
    private String algorithm;

    protected AbstractContentEncryptionAlgorithm(byte[] cek, byte[] iv, String algo) {
        super(algo);
        this.cek = cek;
        this.iv = iv;
        if (iv != null && iv.length > 0) {
            this.providedIvUsageCount = new AtomicInteger();
        }
        this.algorithm = algo;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] getContentEncryptionKey(JweHeaders headers) {
        return this.cek;
    }

    @Override
    public byte[] getInitVector() {
        if (this.iv == null) {
            return CryptoUtils.generateSecureRandomBytes((int)(this.getIvSize() / 8));
        }
        if (this.iv.length > 0 && this.providedIvUsageCount.addAndGet(1) > 1) {
            throw new SecurityException();
        }
        return this.iv;
    }

    protected int getIvSize() {
        return 128;
    }
}

