/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.common.util.crypto.KeyProperties;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.ContentDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionAlgorithm;

public abstract class AbstractJweDecryption
implements JweDecryptionProvider {
    private KeyDecryptionAlgorithm keyDecryptionAlgo;
    private ContentDecryptionAlgorithm contentDecryptionAlgo;

    protected AbstractJweDecryption(KeyDecryptionAlgorithm keyDecryptionAlgo, ContentDecryptionAlgorithm contentDecryptionAlgo) {
        this.keyDecryptionAlgo = keyDecryptionAlgo;
        this.contentDecryptionAlgo = contentDecryptionAlgo;
    }

    protected byte[] getContentEncryptionKey(JweDecryptionInput jweDecryptionInput) {
        return this.keyDecryptionAlgo.getDecryptedContentEncryptionKey(jweDecryptionInput);
    }

    @Override
    public JweDecryptionOutput decrypt(String content) {
        JweCompactConsumer consumer = new JweCompactConsumer(content);
        byte[] cek = this.getContentEncryptionKey(consumer.getJweDecryptionInput());
        return this.doDecrypt(consumer.getJweDecryptionInput(), cek);
    }

    @Override
    public byte[] decrypt(JweDecryptionInput jweDecryptionInput) {
        byte[] cek = this.getContentEncryptionKey(jweDecryptionInput);
        return this.doDecrypt(jweDecryptionInput, cek).getContent();
    }

    protected JweDecryptionOutput doDecrypt(JweDecryptionInput jweDecryptionInput, byte[] cek) {
        KeyProperties keyProperties = new KeyProperties(this.getContentEncryptionAlgorithm(jweDecryptionInput));
        keyProperties.setAdditionalData(this.getContentEncryptionCipherAAD(jweDecryptionInput));
        AlgorithmParameterSpec spec = this.getContentEncryptionCipherSpec(jweDecryptionInput);
        keyProperties.setAlgoSpec(spec);
        boolean compressionSupported = "DEF".equals(jweDecryptionInput.getJweHeaders().getZipAlgorithm());
        keyProperties.setCompressionSupported(compressionSupported);
        byte[] actualCek = this.getActualCek(cek, jweDecryptionInput.getJweHeaders().getContentEncryptionAlgorithm());
        SecretKey secretKey = CryptoUtils.createSecretKeySpec((byte[])actualCek, (String)keyProperties.getKeyAlgo());
        byte[] bytes = CryptoUtils.decryptBytes((byte[])this.getEncryptedContentWithAuthTag(jweDecryptionInput), (Key)secretKey, (KeyProperties)keyProperties);
        return new JweDecryptionOutput(jweDecryptionInput.getJweHeaders(), bytes);
    }

    protected byte[] getEncryptedContentEncryptionKey(JweCompactConsumer consumer) {
        return consumer.getEncryptedContentEncryptionKey();
    }

    protected AlgorithmParameterSpec getContentEncryptionCipherSpec(JweDecryptionInput jweDecryptionInput) {
        return this.contentDecryptionAlgo.getAlgorithmParameterSpec(this.getContentEncryptionCipherInitVector(jweDecryptionInput));
    }

    protected String getContentEncryptionAlgorithm(JweDecryptionInput jweDecryptionInput) {
        return Algorithm.toJavaName(jweDecryptionInput.getJweHeaders().getContentEncryptionAlgorithm());
    }

    protected byte[] getContentEncryptionCipherAAD(JweDecryptionInput jweDecryptionInput) {
        return this.contentDecryptionAlgo.getAdditionalAuthenticationData(jweDecryptionInput.getDecodedJsonHeaders(), jweDecryptionInput.getAad());
    }

    protected byte[] getEncryptedContentWithAuthTag(JweDecryptionInput jweDecryptionInput) {
        return this.contentDecryptionAlgo.getEncryptedSequence(jweDecryptionInput.getJweHeaders(), jweDecryptionInput.getEncryptedContent(), this.getEncryptionAuthenticationTag(jweDecryptionInput));
    }

    protected byte[] getContentEncryptionCipherInitVector(JweDecryptionInput jweDecryptionInput) {
        return jweDecryptionInput.getInitVector();
    }

    protected byte[] getEncryptionAuthenticationTag(JweDecryptionInput jweDecryptionInput) {
        return jweDecryptionInput.getAuthTag();
    }

    protected int getEncryptionAuthenticationTagLenBits(JweDecryptionInput jweDecryptionInput) {
        return this.getEncryptionAuthenticationTag(jweDecryptionInput).length * 8;
    }

    protected byte[] getActualCek(byte[] theCek, String algoJwt) {
        return theCek;
    }

    @Override
    public String getKeyAlgorithm() {
        return this.keyDecryptionAlgo.getAlgorithm();
    }

    @Override
    public String getContentAlgorithm() {
        return this.contentDecryptionAlgo.getAlgorithm();
    }
}

