/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.common.util.crypto.KeyProperties;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AuthenticationTagProducer;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweCompactProducer;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionState;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionAlgorithm;

public abstract class AbstractJweEncryption
implements JweEncryptionProvider {
    protected static final int DEFAULT_AUTH_TAG_LENGTH = 128;
    private ContentEncryptionAlgorithm contentEncryptionAlgo;
    private KeyEncryptionAlgorithm keyEncryptionAlgo;
    private JoseHeadersReaderWriter writer = new JoseHeadersReaderWriter();

    protected AbstractJweEncryption(ContentEncryptionAlgorithm contentEncryptionAlgo, KeyEncryptionAlgorithm keyEncryptionAlgo) {
        this.keyEncryptionAlgo = keyEncryptionAlgo;
        this.contentEncryptionAlgo = contentEncryptionAlgo;
    }

    protected ContentEncryptionAlgorithm getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgo;
    }

    protected AlgorithmParameterSpec getAlgorithmParameterSpec(byte[] theIv) {
        return this.getContentEncryptionAlgorithm().getAlgorithmParameterSpec(theIv);
    }

    protected byte[] getContentEncryptionKey(JweHeaders headers) {
        byte[] cek = this.getProvidedContentEncryptionKey(headers);
        if (cek == null) {
            String algoJava = this.getContentEncryptionAlgoJava();
            String algoJwt = this.getContentEncryptionAlgoJwt();
            cek = CryptoUtils.getSecretKey((String)Algorithm.stripAlgoProperties(algoJava), (int)this.getCekSize(algoJwt)).getEncoded();
        }
        return cek;
    }

    protected int getCekSize(String algoJwt) {
        return Algorithm.valueOf(algoJwt.replace('-', '_')).getKeySizeBits();
    }

    protected byte[] getProvidedContentEncryptionKey(JweHeaders headers) {
        return this.getContentEncryptionAlgorithm().getContentEncryptionKey(headers);
    }

    protected byte[] getEncryptedContentEncryptionKey(JweHeaders headers, byte[] theCek) {
        return this.getKeyEncryptionAlgo().getEncryptedContentEncryptionKey(headers, theCek);
    }

    protected String getContentEncryptionAlgoJwt() {
        return this.getContentEncryptionAlgorithm().getAlgorithm();
    }

    protected String getContentEncryptionAlgoJava() {
        return Algorithm.toJavaName(this.getContentEncryptionAlgoJwt());
    }

    protected byte[] getAAD(String protectedHeaders, byte[] aad) {
        return this.getContentEncryptionAlgorithm().getAdditionalAuthenticationData(protectedHeaders, aad);
    }

    @Override
    public String encrypt(byte[] content, JweHeaders jweHeaders) {
        JweEncryptionInternal state = this.getInternalState(jweHeaders, null);
        byte[] cipher = CryptoUtils.encryptBytes((byte[])content, (Key)this.createCekSecretKey(state), (KeyProperties)state.keyProps);
        JweCompactProducer producer = this.getJweCompactProducer(state, cipher);
        return producer.getJweContent();
    }

    protected JweCompactProducer getJweCompactProducer(JweEncryptionInternal state, byte[] cipher) {
        return new JweCompactProducer(state.theHeaders, state.jweContentEncryptionKey, state.theIv, cipher, 128);
    }

    @Override
    public String getKeyAlgorithm() {
        return this.getKeyEncryptionAlgo().getAlgorithm();
    }

    @Override
    public String getContentAlgorithm() {
        return this.getContentEncryptionAlgorithm().getAlgorithm();
    }

    protected JoseHeadersReaderWriter getJwtHeadersWriter() {
        return this.writer;
    }

    @Override
    public JweEncryptionState createJweEncryptionState(JweEncryptionInput jweInput) {
        JweEncryptionInternal state = this.getInternalState(jweInput.getJweHeaders(), jweInput);
        Cipher c = CryptoUtils.initCipher((Key)this.createCekSecretKey(state), (KeyProperties)state.keyProps, (int)1);
        return new JweEncryptionState(c, state.theHeaders, state.jweContentEncryptionKey, state.theIv, this.getAuthenticationTagProducer(state), state.keyProps.isCompressionSupported());
    }

    protected AuthenticationTagProducer getAuthenticationTagProducer(JweEncryptionInternal state) {
        return null;
    }

    protected SecretKey createCekSecretKey(JweEncryptionInternal state) {
        return CryptoUtils.createSecretKeySpec((byte[])this.getActualCek(state.secretKey, this.getContentEncryptionAlgoJwt()), (String)state.keyProps.getKeyAlgo());
    }

    protected byte[] getActualCek(byte[] theCek, String algoJwt) {
        return theCek;
    }

    private JweEncryptionInternal getInternalState(JweHeaders jweInHeaders, JweEncryptionInput jweInput) {
        JweHeaders theHeaders = new JweHeaders();
        if (this.getKeyAlgorithm() != null) {
            theHeaders.setKeyEncryptionAlgorithm(this.getKeyAlgorithm());
        }
        theHeaders.setContentEncryptionAlgorithm(this.getContentAlgorithm());
        JweHeaders protectedHeaders = null;
        if (jweInHeaders != null) {
            if (jweInHeaders.getKeyEncryptionAlgorithm() != null && (this.getKeyAlgorithm() == null || !this.getKeyAlgorithm().equals(jweInHeaders.getKeyEncryptionAlgorithm())) || jweInHeaders.getAlgorithm() != null && !this.getContentAlgorithm().equals(jweInHeaders.getContentEncryptionAlgorithm())) {
                throw new SecurityException();
            }
            theHeaders.asMap().putAll(jweInHeaders.asMap());
            protectedHeaders = jweInHeaders.getProtectedHeaders() != null ? jweInHeaders.getProtectedHeaders() : theHeaders;
        } else {
            protectedHeaders = theHeaders;
        }
        byte[] theCek = jweInput != null && jweInput.getCek() != null ? jweInput.getCek() : this.getContentEncryptionKey(theHeaders);
        String contentEncryptionAlgoJavaName = Algorithm.toJavaName(this.getContentEncryptionAlgoJwt());
        KeyProperties keyProps = new KeyProperties(contentEncryptionAlgoJavaName);
        keyProps.setCompressionSupported(this.compressionRequired(theHeaders));
        byte[] theIv = jweInput != null && jweInput.getIv() != null ? jweInput.getIv() : this.getContentEncryptionAlgorithm().getInitVector();
        AlgorithmParameterSpec specParams = this.getAlgorithmParameterSpec(theIv);
        keyProps.setAlgoSpec(specParams);
        byte[] jweContentEncryptionKey = this.getEncryptedContentEncryptionKey(theHeaders, theCek);
        String protectedHeadersJson = this.writer.headersToJson(protectedHeaders);
        byte[] additionalEncryptionParam = this.getAAD(protectedHeadersJson, jweInput == null ? null : jweInput.getAad());
        keyProps.setAdditionalData(additionalEncryptionParam);
        JweEncryptionInternal state = new JweEncryptionInternal();
        state.theHeaders = theHeaders;
        state.jweContentEncryptionKey = jweContentEncryptionKey;
        state.keyProps = keyProps;
        state.secretKey = theCek;
        state.theIv = theIv;
        state.protectedHeadersJson = protectedHeadersJson;
        state.aad = jweInput != null ? jweInput.getAad() : null;
        return state;
    }

    private boolean compressionRequired(JweHeaders theHeaders) {
        return "DEF".equals(theHeaders.getZipAlgorithm());
    }

    protected KeyEncryptionAlgorithm getKeyEncryptionAlgo() {
        return this.keyEncryptionAlgo;
    }

    protected static class JweEncryptionInternal {
        JweHeaders theHeaders;
        byte[] jweContentEncryptionKey;
        byte[] theIv;
        KeyProperties keyProps;
        byte[] secretKey;
        String protectedHeadersJson;
        byte[] aad;

        protected JweEncryptionInternal() {
        }
    }
}

