/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AesGcmContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.DirectKeyJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;

public class EcdhDirectKeyJweEncryption
extends DirectKeyJweEncryption {
    public EcdhDirectKeyJweEncryption(ECPublicKey peerPublicKey, String curve, String apuString, String apvString, String ctAlgo) {
        super((ContentEncryptionAlgorithm)new EcdhAesGcmContentEncryptionAlgorithm(peerPublicKey, curve, apuString, apvString, ctAlgo), new EcdhDirectKeyEncryptionAlgorithm());
    }

    protected static class EcdhHelper {
        private ECPublicKey peerPublicKey;
        private String ecurve;
        private byte[] apuBytes;
        private byte[] apvBytes;
        private String ctAlgo;

        public EcdhHelper(ECPublicKey peerPublicKey, String curve, String apuString, String apvString, String ctAlgo) {
            this.ctAlgo = ctAlgo;
            this.peerPublicKey = peerPublicKey;
            this.ecurve = curve;
            this.apuBytes = this.toBytes(apuString);
            this.apvBytes = this.toBytes(apvString);
        }

        public byte[] getDerivedKey(JweHeaders headers) {
            KeyPair pair = CryptoUtils.generateECKeyPair((String)this.ecurve);
            ECPublicKey publicKey = (ECPublicKey)pair.getPublic();
            ECPrivateKey privateKey = (ECPrivateKey)pair.getPrivate();
            Algorithm jwtAlgo = Algorithm.valueOf(this.ctAlgo);
            headers.setHeader("apu", Base64UrlUtility.encode((byte[])this.apuBytes));
            headers.setHeader("apv", Base64UrlUtility.encode((byte[])this.apvBytes));
            headers.setJsonWebKey("epv", JwkUtils.fromECPublicKey(publicKey, this.ecurve));
            return JweUtils.getECDHKey(privateKey, this.peerPublicKey, this.apuBytes, this.apvBytes, jwtAlgo.getJwtName(), jwtAlgo.getKeySizeBits());
        }

        private byte[] toBytes(String str) {
            return str == null ? null : StringUtils.toBytesUTF8((String)str);
        }
    }

    protected static class EcdhAesGcmContentEncryptionAlgorithm
    extends AesGcmContentEncryptionAlgorithm {
        private EcdhHelper helper;

        public EcdhAesGcmContentEncryptionAlgorithm(ECPublicKey peerPublicKey, String curve, String apuString, String apvString, String ctAlgo) {
            super(ctAlgo);
            this.helper = new EcdhHelper(peerPublicKey, curve, apuString, apvString, ctAlgo);
        }

        @Override
        public byte[] getContentEncryptionKey(JweHeaders headers) {
            return this.helper.getDerivedKey(headers);
        }
    }

    protected static class EcdhDirectKeyEncryptionAlgorithm
    extends DirectKeyJweEncryption.DirectKeyEncryptionAlgorithm {
        protected EcdhDirectKeyEncryptionAlgorithm() {
        }

        @Override
        protected void checkKeyEncryptionAlgorithm(JweHeaders headers) {
            headers.setKeyEncryptionAlgorithm("ECDH-ES");
        }
    }
}

