/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.io.UnsupportedEncodingException;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;

public class JweCompactConsumer {
    private JweDecryptionInput jweDecryptionInput;

    public JweCompactConsumer(String jweContent) {
        String[] parts;
        if (jweContent.startsWith("\"") && jweContent.endsWith("\"")) {
            jweContent = jweContent.substring(1, jweContent.length() - 1);
        }
        if ((parts = jweContent.split("\\.")).length != 5) {
            throw new SecurityException("5 JWE parts are expected");
        }
        try {
            String headersJson = new String(Base64UrlUtility.decode((String)parts[0]));
            byte[] encryptedCEK = Base64UrlUtility.decode((String)parts[1]);
            byte[] initVector = Base64UrlUtility.decode((String)parts[2]);
            byte[] encryptedContent = Base64UrlUtility.decode((String)parts[3]);
            byte[] authTag = Base64UrlUtility.decode((String)parts[4]);
            JoseHeadersReaderWriter reader = new JoseHeadersReaderWriter();
            JoseHeaders joseHeaders = reader.fromJsonHeaders(headersJson);
            if (joseHeaders.getUpdateCount() != null) {
                throw new SecurityException("Duplicate headers have been detected");
            }
            JweHeaders jweHeaders = new JweHeaders(joseHeaders);
            this.jweDecryptionInput = new JweDecryptionInput(encryptedCEK, initVector, encryptedContent, authTag, null, headersJson, jweHeaders);
        }
        catch (Base64Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public String getDecodedJsonHeaders() {
        return this.jweDecryptionInput.getDecodedJsonHeaders();
    }

    public JweHeaders getJweHeaders() {
        return this.jweDecryptionInput.getJweHeaders();
    }

    public byte[] getEncryptedContentEncryptionKey() {
        return this.jweDecryptionInput.getEncryptedCEK();
    }

    public byte[] getContentDecryptionCipherInitVector() {
        return this.jweDecryptionInput.getInitVector();
    }

    public byte[] getContentEncryptionCipherAAD() {
        return JweHeaders.toCipherAdditionalAuthData(this.jweDecryptionInput.getDecodedJsonHeaders());
    }

    public byte[] getEncryptionAuthenticationTag() {
        return this.jweDecryptionInput.getAuthTag();
    }

    public byte[] getEncryptedContent() {
        return this.jweDecryptionInput.getEncryptedContent();
    }

    public byte[] getEncryptedContentWithAuthTag() {
        return JweCompactConsumer.getCipherWithAuthTag(this.getEncryptedContent(), this.getEncryptionAuthenticationTag());
    }

    public JweDecryptionInput getJweDecryptionInput() {
        return this.jweDecryptionInput;
    }

    public static byte[] getCipherWithAuthTag(byte[] cipher, byte[] authTag) {
        byte[] encryptedContentWithTag = new byte[cipher.length + authTag.length];
        System.arraycopy(cipher, 0, encryptedContentWithTag, 0, cipher.length);
        System.arraycopy(authTag, 0, encryptedContentWithTag, cipher.length, authTag.length);
        return encryptedContentWithTag;
    }

    public byte[] getDecryptedContent(JweDecryptionProvider decryption) {
        return decryption.decrypt(this.jweDecryptionInput);
    }

    public String getDecryptedContentText(JweDecryptionProvider decryption) {
        try {
            return new String(this.getDecryptedContent(decryption), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new SecurityException(ex);
        }
    }

    public boolean validateCriticalHeaders() {
        return JweUtils.validateCriticalHeaders(this.getJweHeaders());
    }
}

