/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.interfaces.RSAPrivateKey;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsCompactProducer {
    private JoseHeadersReaderWriter writer = new JoseHeadersReaderWriter();
    private JoseHeaders headers;
    private String plainJwsPayload;
    private String signature;

    public JwsCompactProducer(String plainJwsPayload) {
        this(null, null, plainJwsPayload);
    }

    public JwsCompactProducer(JoseHeaders headers, String plainJwsPayload) {
        this(headers, null, plainJwsPayload);
    }

    protected JwsCompactProducer(JoseHeaders headers, JoseHeadersReaderWriter w, String plainJwsPayload) {
        this.headers = headers;
        if (w != null) {
            this.writer = w;
        }
        this.plainJwsPayload = plainJwsPayload;
    }

    public JoseHeaders getJoseHeaders() {
        if (this.headers == null) {
            this.headers = new JoseHeaders();
        }
        return this.headers;
    }

    public String getUnsignedEncodedJws() {
        return this.getUnsignedEncodedJws(false);
    }

    private String getUnsignedEncodedJws(boolean detached) {
        this.checkAlgorithm();
        return Base64UrlUtility.encode((String)this.writer.headersToJson(this.getJoseHeaders())) + "." + (detached ? "" : Base64UrlUtility.encode((String)this.plainJwsPayload));
    }

    public String getEncodedSignature() {
        return this.signature;
    }

    public String getSignedEncodedJws() {
        return this.getSignedEncodedJws(false);
    }

    public String getSignedEncodedJws(boolean detached) {
        this.checkAlgorithm();
        boolean noSignature = StringUtils.isEmpty((String)this.signature);
        if (noSignature && !this.isPlainText()) {
            throw new IllegalStateException("Signature is not available");
        }
        return this.getUnsignedEncodedJws(detached) + "." + (noSignature ? "" : this.signature);
    }

    public String signWith(JsonWebKey jwk) {
        return this.signWith(JwsUtils.getSignatureProvider(jwk, this.headers.getAlgorithm()));
    }

    public String signWith(RSAPrivateKey key) {
        return this.signWith(JwsUtils.getRSAKeySignatureProvider(key, this.headers.getAlgorithm()));
    }

    public String signWith(byte[] key) {
        return this.signWith(JwsUtils.getHmacSignatureProvider(key, this.headers.getAlgorithm()));
    }

    public String signWith(JwsSignatureProvider signer) {
        byte[] bytes = StringUtils.toBytesUTF8((String)this.getUnsignedEncodedJws());
        byte[] sig = signer.sign(this.getJoseHeaders(), bytes);
        return this.setSignatureBytes(sig);
    }

    public String setSignatureText(String signatureText) {
        this.setEncodedSignature(Base64UrlUtility.encode((String)signatureText));
        return this.getSignedEncodedJws();
    }

    public String setSignatureBytes(byte[] signatureOctets) {
        this.setEncodedSignature(Base64UrlUtility.encode((byte[])signatureOctets));
        return this.getSignedEncodedJws();
    }

    private void setEncodedSignature(String sig) {
        this.signature = sig;
    }

    private boolean isPlainText() {
        return "none".equals(this.getAlgorithm());
    }

    private String getAlgorithm() {
        return this.getJoseHeaders().getAlgorithm();
    }

    private void checkAlgorithm() {
        if (this.getAlgorithm() == null) {
            throw new IllegalStateException("Algorithm header is not set");
        }
    }
}

