/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.util.Collections;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsJsonProtectedHeader;
import org.apache.cxf.rs.security.jose.jws.JwsJsonUnprotectedHeader;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsJsonSignatureEntry {
    private String encodedJwsPayload;
    private String encodedProtectedHeader;
    private String encodedSignature;
    private JwsJsonProtectedHeader protectedHeader;
    private JwsJsonUnprotectedHeader unprotectedHeader;
    private JoseHeaders unionHeaders;

    public JwsJsonSignatureEntry(String encodedJwsPayload, String encodedProtectedHeader, String encodedSignature, JwsJsonUnprotectedHeader unprotectedHeader) {
        if (encodedProtectedHeader == null && unprotectedHeader == null || encodedSignature == null) {
            throw new SecurityException("Invalid security entry");
        }
        this.encodedJwsPayload = encodedJwsPayload;
        this.encodedProtectedHeader = encodedProtectedHeader;
        this.encodedSignature = encodedSignature;
        this.unprotectedHeader = unprotectedHeader;
        if (encodedProtectedHeader != null) {
            this.protectedHeader = new JwsJsonProtectedHeader(new JoseHeadersReaderWriter().fromJsonHeaders(JoseUtils.decodeToString(encodedProtectedHeader)));
        }
        this.prepare();
    }

    private void prepare() {
        this.unionHeaders = new JoseHeaders();
        if (this.protectedHeader != null) {
            this.unionHeaders.asMap().putAll(this.protectedHeader.getHeaderEntries().asMap());
        }
        if (this.unprotectedHeader != null) {
            if (!Collections.disjoint(this.unionHeaders.asMap().keySet(), this.unprotectedHeader.getHeaderEntries().asMap().keySet())) {
                throw new SecurityException("Protected and unprotected headers have duplicate values");
            }
            this.unionHeaders.asMap().putAll(this.unprotectedHeader.getHeaderEntries().asMap());
        }
    }

    public String getEncodedJwsPayload() {
        return this.encodedJwsPayload;
    }

    public String getDecodedJwsPayload() {
        return JoseUtils.decodeToString(this.encodedJwsPayload);
    }

    public byte[] getDecodedJwsPayloadBytes() {
        return StringUtils.toBytesUTF8((String)this.getDecodedJwsPayload());
    }

    public String getEncodedProtectedHeader() {
        return this.encodedProtectedHeader;
    }

    public JwsJsonProtectedHeader getProtectedHeader() {
        return this.protectedHeader;
    }

    public JwsJsonUnprotectedHeader getUnprotectedHeader() {
        return this.unprotectedHeader;
    }

    public JoseHeaders getUnionHeader() {
        return this.unionHeaders;
    }

    public String getEncodedSignature() {
        return this.encodedSignature;
    }

    public byte[] getDecodedSignature() {
        return JoseUtils.decode(this.getEncodedSignature());
    }

    public String getUnsignedEncodedSequence() {
        if (this.getEncodedProtectedHeader() != null) {
            return this.getEncodedProtectedHeader() + "." + this.getEncodedJwsPayload();
        }
        return "." + this.getEncodedJwsPayload();
    }

    public String getKeyId() {
        return this.getUnionHeader().getKeyId();
    }

    public boolean verifySignatureWith(JwsSignatureVerifier validator) {
        try {
            return validator.verify(this.getUnionHeader(), this.getUnsignedEncodedSequence(), this.getDecodedSignature());
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public boolean verifySignatureWith(JsonWebKey key) {
        return this.verifySignatureWith(JwsUtils.getSignatureVerifier(key));
    }

    public boolean validateCriticalHeaders() {
        if (this.getUnprotectedHeader().getHeader("crit") != null) {
            return false;
        }
        return JwsUtils.validateCriticalHeaders(this.getUnionHeader());
    }

    public String toJson() {
        return this.toJson(false);
    }

    public String toJson(boolean flattenedMode) {
        StringBuilder sb = new StringBuilder();
        if (!flattenedMode) {
            sb.append("{");
        }
        if (this.protectedHeader != null) {
            sb.append("\"protected\":\"" + this.protectedHeader.getEncodedHeaderEntries() + "\"");
        }
        if (this.unprotectedHeader != null) {
            if (this.protectedHeader != null) {
                sb.append(",");
            }
            sb.append("\"header\":" + this.unprotectedHeader.toJson());
        }
        sb.append(",");
        sb.append("\"signature\":\"" + this.encodedSignature + "\"");
        if (!flattenedMode) {
            sb.append("}");
        }
        return sb.toString();
    }
}

