/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwt;

import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jws.NoneJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;

public abstract class AbstractJoseJwtProducer {
    private JwsSignatureProvider sigProvider;
    private JweEncryptionProvider encryptionProvider;

    protected String processJwt(JwtToken jwt, boolean jwsRequired, boolean jweRequired) {
        JwsJwtCompactProducer jws = new JwsJwtCompactProducer(jwt);
        JwsSignatureProvider theSigProvider = this.getInitializedSigProvider(jweRequired, jwsRequired);
        String data = jws.signWith(theSigProvider);
        JweEncryptionProvider theEncProvider = this.getInitializedEncryptionProvider(jweRequired);
        if (theEncProvider != null) {
            data = theEncProvider.encrypt(StringUtils.toBytesUTF8((String)data), null);
        }
        return data;
    }

    protected JwsSignatureProvider getInitializedSigProvider(boolean jwsRequired, boolean jweRequired) {
        if (this.sigProvider != null) {
            return this.sigProvider;
        }
        JwsSignatureProvider theSigProvider = JwsUtils.loadSignatureProvider(jwsRequired);
        if (theSigProvider == null && jweRequired) {
            return new NoneJwsSignatureProvider();
        }
        throw new SecurityException();
    }

    protected JweEncryptionProvider getInitializedEncryptionProvider(boolean required) {
        if (this.encryptionProvider != null) {
            return this.encryptionProvider;
        }
        return JweUtils.loadEncryptionProvider(required);
    }
}

