/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwt;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtTokenJson;

public class JwtTokenReaderWriter
extends JoseHeadersReaderWriter {
    private static final Set<String> DATE_PROPERTIES = new HashSet<String>(Arrays.asList("exp", "iat", "nbf"));

    public String claimsToJson(JwtClaims claims) {
        return this.toJson(claims);
    }

    public JwtTokenJson tokenToJson(JwtToken token) {
        return new JwtTokenJson(this.toJson(token.getHeaders()), this.toJson(token.getClaims()));
    }

    public JwtClaims fromJsonClaims(String claimsJson) {
        JwtClaims claims = new JwtClaims();
        this.fromJson(claims, claimsJson);
        return claims;
    }

    private JwtToken fromJson(String headersJson, String claimsJson) {
        JoseHeaders headers = this.fromJsonHeaders(headersJson);
        JwtClaims claims = this.fromJsonClaims(claimsJson);
        return new JwtToken(headers, claims);
    }

    public JwtToken fromJson(JwtTokenJson pair) {
        return this.fromJson(pair.getHeadersJson(), pair.getClaimsJson());
    }

    protected Object readPrimitiveValue(String name, String json, int from, int to) {
        Object value = super.readPrimitiveValue(name, json, from, to);
        if (DATE_PROPERTIES.contains(name)) {
            value = Long.valueOf(value.toString());
        }
        return value;
    }
}

