/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;

public class AesGcmWrapKeyEncryptionAlgorithm
extends AbstractWrapKeyEncryptionAlgorithm {
    private static final Set<String> SUPPORTED_ALGORITHMS = new HashSet<String>(Arrays.asList(Algorithm.A128GCMKW.getJwtName(), Algorithm.A192GCMKW.getJwtName(), Algorithm.A256GCMKW.getJwtName()));

    public AesGcmWrapKeyEncryptionAlgorithm(String encodedKey, String keyAlgoJwt) {
        this(CryptoUtils.decodeSequence((String)encodedKey), keyAlgoJwt);
    }

    public AesGcmWrapKeyEncryptionAlgorithm(byte[] keyBytes, String keyAlgoJwt) {
        this(CryptoUtils.createSecretKeySpec((byte[])keyBytes, (String)"AES"), keyAlgoJwt);
    }

    public AesGcmWrapKeyEncryptionAlgorithm(SecretKey key, String keyAlgoJwt) {
        super(key, keyAlgoJwt, true, SUPPORTED_ALGORITHMS);
    }

    @Override
    public byte[] getEncryptedContentEncryptionKey(JweHeaders headers, byte[] cek) {
        byte[] wrappedKeyAndTag = super.getEncryptedContentEncryptionKey(headers, cek);
        byte[] wrappedKey = new byte[wrappedKeyAndTag.length - 16];
        System.arraycopy(wrappedKeyAndTag, 0, wrappedKey, 0, wrappedKeyAndTag.length - 16);
        String encodedTag = Base64UrlUtility.encodeChunk((byte[])wrappedKeyAndTag, (int)(wrappedKeyAndTag.length - 16), (int)16);
        headers.setHeader("tag", encodedTag);
        return wrappedKey;
    }

    @Override
    protected AlgorithmParameterSpec getAlgorithmParameterSpec(JweHeaders headers) {
        byte[] iv = CryptoUtils.generateSecureRandomBytes((int)12);
        String encodedIv = Base64UrlUtility.encode((byte[])iv);
        headers.setHeader("iv", encodedIv);
        return CryptoUtils.getContentEncryptionCipherSpec((int)128, (byte[])iv);
    }
}

