/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.common.util.crypto.KeyProperties;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionInput;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionAlgorithm;

public class WrappedKeyDecryptionAlgorithm
implements KeyDecryptionAlgorithm {
    private Key cekDecryptionKey;
    private boolean unwrap;
    private String supportedAlgo;

    public WrappedKeyDecryptionAlgorithm(Key cekDecryptionKey, String supportedAlgo) {
        this(cekDecryptionKey, supportedAlgo, true);
    }

    public WrappedKeyDecryptionAlgorithm(Key cekDecryptionKey, String supportedAlgo, boolean unwrap) {
        this.cekDecryptionKey = cekDecryptionKey;
        this.supportedAlgo = supportedAlgo;
        this.unwrap = unwrap;
    }

    @Override
    public byte[] getDecryptedContentEncryptionKey(JweDecryptionInput jweDecryptionInput) {
        KeyProperties keyProps = new KeyProperties(this.getKeyEncryptionAlgorithm(jweDecryptionInput));
        AlgorithmParameterSpec spec = this.getAlgorithmParameterSpec(jweDecryptionInput);
        if (spec != null) {
            keyProps.setAlgoSpec(spec);
        }
        if (!this.unwrap) {
            keyProps.setBlockSize(this.getKeyCipherBlockSize());
            return CryptoUtils.decryptBytes((byte[])this.getEncryptedContentEncryptionKey(jweDecryptionInput), (Key)this.getCekDecryptionKey(), (KeyProperties)keyProps);
        }
        return CryptoUtils.unwrapSecretKey((byte[])this.getEncryptedContentEncryptionKey(jweDecryptionInput), (String)this.getContentEncryptionAlgorithm(jweDecryptionInput), (Key)this.getCekDecryptionKey(), (KeyProperties)keyProps).getEncoded();
    }

    protected Key getCekDecryptionKey() {
        return this.cekDecryptionKey;
    }

    protected int getKeyCipherBlockSize() {
        return -1;
    }

    protected String getKeyEncryptionAlgorithm(JweDecryptionInput jweDecryptionInput) {
        String keyAlgo = jweDecryptionInput.getJweHeaders().getKeyEncryptionAlgorithm();
        this.validateKeyEncryptionAlgorithm(keyAlgo);
        return Algorithm.toJavaName(keyAlgo);
    }

    protected void validateKeyEncryptionAlgorithm(String keyAlgo) {
        if (keyAlgo == null || this.supportedAlgo != null && !this.supportedAlgo.equals(keyAlgo)) {
            throw new SecurityException();
        }
    }

    protected String getContentEncryptionAlgorithm(JweDecryptionInput jweDecryptionInput) {
        return Algorithm.toJavaName(jweDecryptionInput.getJweHeaders().getContentEncryptionAlgorithm());
    }

    protected AlgorithmParameterSpec getAlgorithmParameterSpec(JweDecryptionInput jweDecryptionInput) {
        return null;
    }

    protected byte[] getEncryptedContentEncryptionKey(JweDecryptionInput jweDecryptionInput) {
        return jweDecryptionInput.getEncryptedCEK();
    }

    @Override
    public String getAlgorithm() {
        return this.supportedAlgo;
    }
}

