/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server.util;

import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class Utils {
    private Utils() {
    }

    public static <T> Enumeration<T> emptyEnumeration() {
        return Collections.enumeration(Collections.emptySet());
    }

    public static <T> Enumeration<T> enumeration(Collection<T> collection) {
        if (collection == null) {
            return Utils.emptyEnumeration();
        }
        return Collections.enumeration(collection);
    }

    public static <T> Enumeration<T> enumerationFromKeys(Map<T, ?> map) {
        if (map == null) {
            return Utils.emptyEnumeration();
        }
        return Collections.enumeration(map.keySet());
    }

    public static <T> Enumeration<T> enumerationFromValues(Map<?, T> map) {
        if (map == null) {
            return Utils.emptyEnumeration();
        }
        return Collections.enumeration(map.values());
    }

    public static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int start = contentType.indexOf("charset=");
        if (start < 0) {
            return null;
        }
        String encoding = contentType.substring(start + 8);
        int end = encoding.indexOf(59);
        if (end >= 0) {
            encoding = encoding.substring(0, end);
        }
        if ((encoding = encoding.trim()).length() > 2 && encoding.startsWith("\"") && encoding.endsWith("\"")) {
            encoding = encoding.substring(1, encoding.length() - 1);
        }
        return encoding.trim();
    }

    public static Collection<Cookie> getCookies(String name, HttpRequest request) {
        String cookieString = request.headers().get("Cookie");
        if (cookieString != null) {
            ArrayList<Cookie> foundCookie = new ArrayList<Cookie>();
            Set cookies = CookieDecoder.decode((String)cookieString);
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                foundCookie.add(cookie);
            }
            return foundCookie;
        }
        return null;
    }

    public static Collection<Cookie> getCookies(String name, HttpResponse response) {
        String cookieString = response.headers().get("Cookie");
        if (cookieString != null) {
            ArrayList<Cookie> foundCookie = new ArrayList<Cookie>();
            Set cookies = CookieDecoder.decode((String)cookieString);
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                foundCookie.add(cookie);
            }
            return foundCookie;
        }
        return null;
    }

    public static String getMimeType(String fileUrl) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        return fileNameMap.getContentTypeFor(fileUrl);
    }

    public static String sanitizeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                uri = URLDecoder.decode(uri, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e1) {
                throw new Error();
            }
        }
        uri = uri.replace('/', File.separatorChar);
        if (uri.contains(File.separator + ".") || uri.contains("." + File.separator) || uri.startsWith(".") || uri.endsWith(".")) {
            return null;
        }
        return uri;
    }

    public static Collection<Locale> parseAcceptLanguageHeader(String acceptLanguageHeader) {
        if (acceptLanguageHeader == null) {
            return null;
        }
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String str : acceptLanguageHeader.split(",")) {
            String[] arr = str.trim().replace("-", "_").split(";");
            Locale locale = null;
            String[] l = arr[0].split("_");
            switch (l.length) {
                case 2: {
                    locale = new Locale(l[0], l[1]);
                    break;
                }
                case 3: {
                    locale = new Locale(l[0], l[1], l[2]);
                    break;
                }
                default: {
                    locale = new Locale(l[0]);
                }
            }
            locales.add(locale);
        }
        return locales;
    }
}

