/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.jaxrs.PrivateKeyPasswordProvider;
import org.apache.cxf.security.SecurityContext;

public final class KeyManagementUtils {
    public static final String RSSEC_KEY_STORE_TYPE = "rs.security.keystore.type";
    public static final String RSSEC_KEY_STORE_PSWD = "rs.security.keystore.password";
    public static final String RSSEC_KEY_PSWD = "rs.security.key.password";
    public static final String RSSEC_KEY_STORE_ALIAS = "rs.security.keystore.alias";
    public static final String RSSEC_KEY_STORE_ALIASES = "rs.security.keystore.aliases";
    public static final String RSSEC_KEY_STORE_FILE = "rs.security.keystore.file";
    public static final String RSSEC_PRINCIPAL_NAME = "rs.security.principal.name";
    public static final String RSSEC_KEY_PSWD_PROVIDER = "rs.security.key.password.provider";
    public static final String RSSEC_SIG_KEY_PSWD_PROVIDER = "rs.security.signature.key.password.provider";
    public static final String RSSEC_DECRYPT_KEY_PSWD_PROVIDER = "rs.security.decryption.key.password.provider";
    public static final String RSSEC_DEFAULT_ALGORITHMS = "rs.security.default.algorithms";
    public static final String RSSEC_REPORT_KEY_PROP = "rs.security.report.public.key";

    private KeyManagementUtils() {
    }

    public static List<String> loadAndEncodeX509CertificateOrChain(Message m, Properties props) {
        X509Certificate[] chain = KeyManagementUtils.loadX509CertificateOrChain(m, props);
        return KeyManagementUtils.encodeX509CertificateChain(chain);
    }

    public static X509Certificate[] loadX509CertificateOrChain(Message m, Properties props) {
        KeyStore keyStore = KeyManagementUtils.loadPersistKeyStore(m, props);
        String alias = props.getProperty(RSSEC_KEY_STORE_ALIAS);
        return KeyManagementUtils.loadX509CertificateOrChain(keyStore, alias);
    }

    private static X509Certificate[] loadX509CertificateOrChain(KeyStore keyStore, String alias) {
        try {
            Certificate[] certs = keyStore.getCertificateChain(alias);
            if (certs != null) {
                return (X509Certificate[])Arrays.copyOf(certs, certs.length, X509Certificate[].class);
            }
            return new X509Certificate[]{(X509Certificate)CryptoUtils.loadCertificate((KeyStore)keyStore, (String)alias)};
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static PublicKey loadPublicKey(Message m, Properties props) {
        KeyStore keyStore = KeyManagementUtils.loadPersistKeyStore(m, props);
        return CryptoUtils.loadPublicKey((KeyStore)keyStore, (String)props.getProperty(RSSEC_KEY_STORE_ALIAS));
    }

    public static PublicKey loadPublicKey(Message m, String keyStoreLocProp) {
        return KeyManagementUtils.loadPublicKey(m, keyStoreLocProp, null);
    }

    public static PublicKey loadPublicKey(Message m, String keyStoreLocPropPreferred, String keyStoreLocPropDefault) {
        String keyStoreLoc = KeyManagementUtils.getMessageProperty(m, keyStoreLocPropPreferred, keyStoreLocPropDefault);
        Bus bus = m.getExchange().getBus();
        try {
            Properties props = ResourceUtils.loadProperties((String)keyStoreLoc, (Bus)bus);
            return KeyManagementUtils.loadPublicKey(m, props);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    private static String getMessageProperty(Message m, String keyStoreLocPropPreferred, String keyStoreLocPropDefault) {
        String propLoc = (String)MessageUtils.getContextualProperty((Message)m, (String)keyStoreLocPropPreferred, (String)keyStoreLocPropDefault);
        if (propLoc == null) {
            throw new SecurityException();
        }
        return propLoc;
    }

    private static PrivateKey loadPrivateKey(KeyStore keyStore, Message m, Properties props, Bus bus, PrivateKeyPasswordProvider provider, String keyOper, String alias) {
        String theAlias;
        String keyPswd = props.getProperty(RSSEC_KEY_PSWD);
        String string = theAlias = alias != null ? alias : KeyManagementUtils.getKeyId(m, props, RSSEC_KEY_STORE_ALIAS, keyOper);
        char[] keyPswdChars = provider != null ? provider.getPassword(props) : (char[])(keyPswd != null ? keyPswd.toCharArray() : null);
        return CryptoUtils.loadPrivateKey((KeyStore)keyStore, (char[])keyPswdChars, (String)theAlias);
    }

    public static PrivateKey loadPrivateKey(Message m, String keyStoreLocProp, String keyOper) {
        return KeyManagementUtils.loadPrivateKey(m, keyStoreLocProp, null, keyOper);
    }

    public static PrivateKey loadPrivateKey(Message m, String keyStoreLocPropPreferred, String keyStoreLocPropDefault, String keyOper) {
        String keyStoreLoc = KeyManagementUtils.getMessageProperty(m, keyStoreLocPropPreferred, keyStoreLocPropDefault);
        Bus bus = m.getExchange().getBus();
        try {
            Properties props = ResourceUtils.loadProperties((String)keyStoreLoc, (Bus)bus);
            return KeyManagementUtils.loadPrivateKey(m, props, keyOper);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static String getKeyId(Message m, Properties props, String preferredPropertyName, String keyOper) {
        String kid = null;
        String altPropertyName = null;
        if (keyOper != null) {
            if (keyOper.equals("encrypt") || keyOper.equals("decrypt")) {
                altPropertyName = preferredPropertyName + ".jwe";
            } else if (keyOper.equals("sign") || keyOper.equals("verify")) {
                altPropertyName = preferredPropertyName + ".jws";
            }
            String direction = m.getExchange().getOutMessage() == m ? ".out" : ".in";
            kid = (String)MessageUtils.getContextualProperty((Message)m, (String)preferredPropertyName, (String)(altPropertyName + direction));
        }
        if (kid == null) {
            kid = props.getProperty(preferredPropertyName);
        }
        if (kid == null && altPropertyName != null) {
            kid = props.getProperty(altPropertyName);
        }
        return kid;
    }

    public static PrivateKeyPasswordProvider loadPasswordProvider(Message m, Properties props, String keyOper) {
        PrivateKeyPasswordProvider cb = (PrivateKeyPasswordProvider)m.getContextualProperty(RSSEC_KEY_PSWD_PROVIDER);
        if (cb == null && keyOper != null) {
            String propName;
            String string = keyOper.equals("sign") ? RSSEC_SIG_KEY_PSWD_PROVIDER : (propName = keyOper.equals("decrypt") ? RSSEC_DECRYPT_KEY_PSWD_PROVIDER : null);
            if (propName != null) {
                cb = (PrivateKeyPasswordProvider)m.getContextualProperty(propName);
            }
        }
        return cb;
    }

    public static RSAPrivateKey loadPrivateKey(Message m, Properties props, String keyOper) {
        KeyStore keyStore = KeyManagementUtils.loadPersistKeyStore(m, props);
        return KeyManagementUtils.loadPrivateKey(keyStore, m, props, keyOper, null);
    }

    private static RSAPrivateKey loadPrivateKey(KeyStore keyStore, Message m, Properties props, String keyOper, String alias) {
        Principal p;
        SecurityContext sc;
        Bus bus = m.getExchange().getBus();
        PrivateKeyPasswordProvider cb = KeyManagementUtils.loadPasswordProvider(m, props, keyOper);
        if (cb != null && m.getExchange().getInMessage() != null && (sc = (SecurityContext)m.getExchange().getInMessage().get(SecurityContext.class)) != null && (p = sc.getUserPrincipal()) != null) {
            props.setProperty(RSSEC_PRINCIPAL_NAME, p.getName());
        }
        return (RSAPrivateKey)KeyManagementUtils.loadPrivateKey(keyStore, m, props, bus, cb, keyOper, alias);
    }

    public static KeyStore loadPersistKeyStore(Message m, Properties props) {
        KeyStore keyStore = (KeyStore)m.getExchange().get(props.get(RSSEC_KEY_STORE_FILE));
        if (keyStore == null) {
            keyStore = KeyManagementUtils.loadKeyStore(props, m.getExchange().getBus());
            m.getExchange().put((Object)((String)props.get(RSSEC_KEY_STORE_FILE)), (Object)keyStore);
        }
        return keyStore;
    }

    public static KeyStore loadKeyStore(Properties props, Bus bus) {
        String keyStoreType = props.getProperty(RSSEC_KEY_STORE_TYPE);
        String keyStoreLoc = props.getProperty(RSSEC_KEY_STORE_FILE);
        String keyStorePswd = props.getProperty(RSSEC_KEY_STORE_PSWD);
        try {
            InputStream is = ResourceUtils.getResourceStream((String)keyStoreLoc, (Bus)bus);
            return CryptoUtils.loadKeyStore((InputStream)is, (char[])keyStorePswd.toCharArray(), (String)keyStoreType);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public static List<String> encodeX509CertificateChain(X509Certificate[] chain) {
        return KeyManagementUtils.encodeX509CertificateChain(Arrays.asList(chain));
    }

    public static List<String> encodeX509CertificateChain(List<X509Certificate> chain) {
        ArrayList<String> encodedChain = new ArrayList<String>(chain.size());
        for (X509Certificate cert : chain) {
            try {
                encodedChain.add(CryptoUtils.encodeCertificate((Certificate)cert));
            }
            catch (Exception ex) {
                throw new SecurityException(ex);
            }
        }
        return encodedChain;
    }

    public static List<X509Certificate> toX509CertificateChain(List<String> base64EncodedChain) {
        if (base64EncodedChain != null) {
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(base64EncodedChain.size());
            for (String encodedCert : base64EncodedChain) {
                try {
                    certs.add((X509Certificate)CryptoUtils.decodeCertificate((String)encodedCert));
                }
                catch (Exception ex) {
                    throw new SecurityException(ex);
                }
            }
            return certs;
        }
        return null;
    }

    public static String getKeyAlgorithm(Message m, Properties props, String propName, String defaultAlg) {
        String algo = props.getProperty(propName);
        if (algo == null && PropertyUtils.isTrue((Object)m.getContextualProperty(RSSEC_DEFAULT_ALGORITHMS))) {
            algo = defaultAlg;
        }
        return algo;
    }

    public static Properties loadStoreProperties(Message m, boolean required, String storeProp1, String storeProp2) {
        if (m == null) {
            if (required) {
                throw new SecurityException();
            }
            return null;
        }
        Properties props = null;
        String propLoc = (String)MessageUtils.getContextualProperty((Message)m, (String)storeProp1, (String)storeProp2);
        if (propLoc != null) {
            try {
                props = ResourceUtils.loadProperties((String)propLoc, (Bus)m.getExchange().getBus());
            }
            catch (Exception ex) {
                throw new SecurityException(ex);
            }
        } else {
            String keyFile = (String)m.getContextualProperty(RSSEC_KEY_STORE_FILE);
            if (keyFile != null) {
                props = new Properties();
                props.setProperty(RSSEC_KEY_STORE_FILE, keyFile);
                String type = (String)m.getContextualProperty(RSSEC_KEY_STORE_TYPE);
                if (type == null) {
                    type = "jwk";
                }
                props.setProperty(RSSEC_KEY_STORE_TYPE, type);
            }
        }
        if (props == null && required) {
            throw new SecurityException();
        }
        return props;
    }

    public static RSAPrivateKey loadPrivateKey(Message m, Properties props, List<X509Certificate> inCert, String keyOper) {
        KeyStore keyStore = KeyManagementUtils.loadPersistKeyStore(m, props);
        try {
            Object[] inCertArray = inCert.toArray();
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Object[] chain = KeyManagementUtils.loadX509CertificateOrChain(keyStore, alias);
                if (chain == null || !Arrays.equals(chain, inCertArray)) continue;
                return KeyManagementUtils.loadPrivateKey(keyStore, m, props, keyOper, alias);
            }
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
        return null;
    }
}

