/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import javax.crypto.SecretKey;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.WrappedKeyDecryptionAlgorithm;

public class AesWrapKeyDecryptionAlgorithm
extends WrappedKeyDecryptionAlgorithm {
    public AesWrapKeyDecryptionAlgorithm(String encodedKey) {
        this(encodedKey, null);
    }

    public AesWrapKeyDecryptionAlgorithm(String encodedKey, String supportedAlgo) {
        this(CryptoUtils.decodeSequence((String)encodedKey), supportedAlgo);
    }

    public AesWrapKeyDecryptionAlgorithm(byte[] secretKey) {
        this(secretKey, null);
    }

    public AesWrapKeyDecryptionAlgorithm(byte[] secretKey, String supportedAlgo) {
        this(CryptoUtils.createSecretKeySpec((byte[])secretKey, (String)"AESWrap"), supportedAlgo);
    }

    public AesWrapKeyDecryptionAlgorithm(SecretKey secretKey) {
        this(secretKey, null);
    }

    public AesWrapKeyDecryptionAlgorithm(SecretKey secretKey, String supportedAlgo) {
        super(secretKey, supportedAlgo);
    }

    @Override
    protected void validateKeyEncryptionAlgorithm(String keyAlgo) {
        super.validateKeyEncryptionAlgorithm(keyAlgo);
        if (!this.isValidAlgorithmFamily(keyAlgo)) {
            throw new SecurityException();
        }
    }

    protected boolean isValidAlgorithmFamily(String keyAlgo) {
        return Algorithm.isAesKeyWrap(keyAlgo);
    }
}

