/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.Key;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractWrapKeyEncryptionAlgorithm;

public class AesWrapKeyEncryptionAlgorithm
extends AbstractWrapKeyEncryptionAlgorithm {
    private static final Set<String> SUPPORTED_ALGORITHMS = new HashSet<String>(Arrays.asList(Algorithm.A128KW.getJwtName(), Algorithm.A192KW.getJwtName(), Algorithm.A256KW.getJwtName()));

    public AesWrapKeyEncryptionAlgorithm(String encodedKey, String keyAlgoJwt) {
        this(CryptoUtils.decodeSequence((String)encodedKey), keyAlgoJwt);
    }

    public AesWrapKeyEncryptionAlgorithm(byte[] keyBytes, String keyAlgoJwt) {
        this(CryptoUtils.createSecretKeySpec((byte[])keyBytes, (String)Algorithm.toJavaName(keyAlgoJwt)), keyAlgoJwt);
    }

    public AesWrapKeyEncryptionAlgorithm(SecretKey key, String keyAlgoJwt) {
        super((Key)key, keyAlgoJwt, SUPPORTED_ALGORITHMS);
    }
}

