/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import org.apache.cxf.rs.security.jose.jwe.AbstractJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionAlgorithm;

public class DirectKeyJweEncryption
extends AbstractJweEncryption {
    public DirectKeyJweEncryption(ContentEncryptionAlgorithm ceAlgo) {
        this(ceAlgo, new DirectKeyEncryptionAlgorithm());
    }

    protected DirectKeyJweEncryption(ContentEncryptionAlgorithm ceAlgo, DirectKeyEncryptionAlgorithm direct) {
        super(ceAlgo, direct);
    }

    @Override
    protected byte[] getProvidedContentEncryptionKey(JweHeaders headers) {
        return DirectKeyJweEncryption.validateCek(super.getProvidedContentEncryptionKey(headers));
    }

    private static byte[] validateCek(byte[] cek) {
        if (cek == null) {
            throw new NullPointerException("CEK must not be null");
        }
        return cek;
    }

    protected static class DirectKeyEncryptionAlgorithm
    implements KeyEncryptionAlgorithm {
        protected DirectKeyEncryptionAlgorithm() {
        }

        @Override
        public byte[] getEncryptedContentEncryptionKey(JweHeaders headers, byte[] theCek) {
            if (headers.getKeyEncryptionAlgorithm() != null) {
                throw new SecurityException();
            }
            return new byte[0];
        }

        protected void checkKeyEncryptionAlgorithm(JweHeaders headers) {
            if (headers.getKeyEncryptionAlgorithm() != null) {
                throw new SecurityException();
            }
        }

        @Override
        public String getAlgorithm() {
            return null;
        }
    }
}

