/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.interfaces.ECPrivateKey;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AesWrapKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.EcdhDirectKeyJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionInput;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionAlgorithm;

public class EcdhAesWrapKeyDecryptionAlgorithm
implements KeyDecryptionAlgorithm {
    private ECPrivateKey key;
    private String algo;

    public EcdhAesWrapKeyDecryptionAlgorithm(ECPrivateKey key) {
        this(key, Algorithm.ECDH_ES_A128KW.getJwtName());
    }

    public EcdhAesWrapKeyDecryptionAlgorithm(ECPrivateKey key, String algo) {
        this.key = key;
        this.algo = algo;
    }

    @Override
    public byte[] getDecryptedContentEncryptionKey(JweDecryptionInput jweDecryptionInput) {
        byte[] derivedKey = EcdhDirectKeyJweDecryption.getDecryptedContentEncryptionKeyFromHeaders(jweDecryptionInput.getJweHeaders(), this.key);
        AesWrapKeyDecryptionAlgorithm aesWrap = new AesWrapKeyDecryptionAlgorithm(derivedKey){

            @Override
            protected boolean isValidAlgorithmFamily(String wrapAlgo) {
                return Algorithm.isEcdhEsWrap(wrapAlgo);
            }
        };
        return aesWrap.getDecryptedContentEncryptionKey(jweDecryptionInput);
    }

    @Override
    public String getAlgorithm() {
        return this.algo;
    }
}

