/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.interfaces.ECPublicKey;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AesWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.EcdhDirectKeyJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionAlgorithm;

public class EcdhAesWrapKeyEncryptionAlgorithm
implements KeyEncryptionAlgorithm {
    private static final Map<String, String> ECDH_AES_MAP = new HashMap<String, String>();
    private String keyAlgo;
    private EcdhDirectKeyJweEncryption.EcdhHelper helper;

    public EcdhAesWrapKeyEncryptionAlgorithm(ECPublicKey peerPublicKey, String curve, String apuString, String apvString, String keyAlgo) {
        this.keyAlgo = keyAlgo;
        this.helper = new EcdhDirectKeyJweEncryption.EcdhHelper(peerPublicKey, curve, apuString, apvString, keyAlgo);
    }

    @Override
    public byte[] getEncryptedContentEncryptionKey(JweHeaders headers, byte[] cek) {
        byte[] derivedKey = this.helper.getDerivedKey(headers);
        Algorithm jwtAlgo = Algorithm.valueOf(ECDH_AES_MAP.get(this.keyAlgo));
        AesWrapKeyEncryptionAlgorithm aesWrap = new AesWrapKeyEncryptionAlgorithm(derivedKey, jwtAlgo.getJwtName()){

            @Override
            protected void checkAlgorithms(JweHeaders headers) {
            }

            @Override
            protected String getKeyEncryptionAlgoJava(JweHeaders headers) {
                return "AESWrap";
            }
        };
        return aesWrap.getEncryptedContentEncryptionKey(headers, cek);
    }

    @Override
    public String getAlgorithm() {
        return this.keyAlgo;
    }

    static {
        ECDH_AES_MAP.put(Algorithm.ECDH_ES_A128KW.getJwtName(), Algorithm.A128KW.getJwtName());
        ECDH_AES_MAP.put(Algorithm.ECDH_ES_A192KW.getJwtName(), Algorithm.A192KW.getJwtName());
        ECDH_AES_MAP.put(Algorithm.ECDH_ES_A256KW.getJwtName(), Algorithm.A256KW.getJwtName());
    }
}

