/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jws.AbstractJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;

public class PrivateKeyJwsSignatureProvider
extends AbstractJwsSignatureProvider {
    private PrivateKey key;
    private SecureRandom random;
    private AlgorithmParameterSpec signatureSpec;

    public PrivateKeyJwsSignatureProvider(PrivateKey key, String algo) {
        this(key, null, algo);
    }

    public PrivateKeyJwsSignatureProvider(PrivateKey key, AlgorithmParameterSpec spec, String algo) {
        this(key, null, spec, algo);
    }

    public PrivateKeyJwsSignatureProvider(PrivateKey key, SecureRandom random, AlgorithmParameterSpec spec, String algo) {
        super(algo);
        this.key = key;
        this.random = random;
        this.signatureSpec = spec;
    }

    @Override
    protected JwsSignature doCreateJwsSignature(JoseHeaders headers) {
        Signature s = CryptoUtils.getSignature((PrivateKey)this.key, (String)Algorithm.toJavaName(headers.getAlgorithm()), (SecureRandom)this.random, (AlgorithmParameterSpec)this.signatureSpec);
        return this.doCreateJwsSignature(s);
    }

    protected JwsSignature doCreateJwsSignature(Signature s) {
        return new PrivateKeyJwsSignature(s);
    }

    @Override
    protected void checkAlgorithm(String algo) {
        super.checkAlgorithm(algo);
        if (!this.isValidAlgorithmFamily(algo)) {
            throw new SecurityException();
        }
    }

    protected boolean isValidAlgorithmFamily(String algo) {
        return Algorithm.isRsaSign(algo);
    }

    protected static class PrivateKeyJwsSignature
    implements JwsSignature {
        private Signature s;

        public PrivateKeyJwsSignature(Signature s) {
            this.s = s;
        }

        @Override
        public void update(byte[] src, int off, int len) {
            try {
                this.s.update(src, off, len);
            }
            catch (SignatureException ex) {
                throw new SecurityException();
            }
        }

        @Override
        public byte[] sign() {
            try {
                return this.s.sign();
            }
            catch (SignatureException ex) {
                ex.printStackTrace();
                throw new SecurityException();
            }
        }
    }
}

