/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oauth2.client.ClientCodeStateManager;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContext;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContextManager;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrant;

@PreMatching
@Priority(value=1001)
public class ClientCodeRequestFilter
implements ContainerRequestFilter {
    @Context
    private MessageContext mc;
    private String scopes;
    private String relRedirectUri;
    private String startUri;
    private String authorizationServiceUri;
    private OAuthClientUtils.Consumer consumer;
    private ClientCodeStateManager clientStateManager;
    private ClientTokenContextManager clientTokenContextManager;
    private WebClient accessTokenService;

    public void filter(ContainerRequestContext rc) throws IOException {
        SecurityContext sc = rc.getSecurityContext();
        if (sc == null || sc.getUserPrincipal() == null) {
            throw ExceptionUtils.toNotAuthorizedException(null, null);
        }
        UriInfo ui = rc.getUriInfo();
        if (ui.getPath().endsWith(this.startUri)) {
            ClientTokenContext request;
            if (this.clientTokenContextManager != null && (request = this.clientTokenContextManager.getClientTokenContext(this.mc)) != null) {
                this.setClientCodeRequest(request);
                rc.setRequestUri(URI.create(this.relRedirectUri));
                return;
            }
            Response codeResponse = this.createCodeResponse(rc, sc, ui);
            rc.abortWith(codeResponse);
        } else if (ui.getPath().endsWith(this.relRedirectUri)) {
            this.processCodeResponse(rc, sc, ui);
        }
    }

    private Response createCodeResponse(ContainerRequestContext rc, SecurityContext sc, UriInfo ui) {
        URI uri = OAuthClientUtils.getAuthorizationURI(this.authorizationServiceUri, this.consumer.getKey(), this.getAbsoluteRedirectUri(ui).toString(), this.createRequestState(rc, sc, ui), this.scopes);
        return Response.seeOther((URI)uri).build();
    }

    private URI getAbsoluteRedirectUri(UriInfo ui) {
        return ui.getBaseUriBuilder().path(this.relRedirectUri).build(new Object[0]);
    }

    protected void processCodeResponse(ContainerRequestContext rc, SecurityContext sc, UriInfo ui) {
        MultivaluedMap params = ui.getQueryParameters();
        String codeParam = (String)params.getFirst((Object)"code");
        AuthorizationCodeGrant grant = new AuthorizationCodeGrant(codeParam, this.getAbsoluteRedirectUri(ui));
        ClientAccessToken at = OAuthClientUtils.getAccessToken(this.accessTokenService, this.consumer, grant);
        MultivaluedMap<String, String> state = null;
        String stateParam = (String)params.getFirst((Object)"state");
        if (this.clientStateManager != null) {
            state = this.clientStateManager.toState(this.mc, stateParam);
        }
        ClientTokenContext request = this.createTokenContext(at);
        request.setToken(at);
        request.setState(state);
        if (this.clientTokenContextManager != null) {
            this.clientTokenContextManager.setClientTokenContext(this.mc, request);
        }
        this.setClientCodeRequest(request);
    }

    protected ClientTokenContext createTokenContext(ClientAccessToken at) {
        return new ClientTokenContext();
    }

    private void setClientCodeRequest(ClientTokenContext request) {
        JAXRSUtils.getCurrentMessage().setContent(ClientTokenContext.class, (Object)request);
    }

    private String createRequestState(ContainerRequestContext rc, SecurityContext sc, UriInfo ui) {
        if (this.clientStateManager == null) {
            return null;
        }
        MetadataMap state = new MetadataMap();
        state.putAll((Map)ui.getQueryParameters(false));
        if (MediaType.APPLICATION_FORM_URLENCODED_TYPE.isCompatible(rc.getMediaType())) {
            String body = FormUtils.readBody((InputStream)rc.getEntityStream(), (String)"UTF-8");
            FormUtils.populateMapFromString((MultivaluedMap)state, (Message)JAXRSUtils.getCurrentMessage(), (String)body, (String)"UTF-8", (boolean)false);
        }
        return this.clientStateManager.toString(this.mc, (MultivaluedMap<String, String>)state);
    }

    public void setScopeList(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(s);
        }
        this.setScopeString(sb.toString());
    }

    public void setScopeString(String scopesString) {
        this.scopes = scopesString;
    }

    public void setStartUri(String startUri) {
        this.startUri = startUri;
    }

    public void setAuthorizationServiceUri(String authorizationServiceUri) {
        this.authorizationServiceUri = authorizationServiceUri;
    }

    public void setRelativeRedirectUri(String redirectUri) {
        this.relRedirectUri = redirectUri;
    }

    public void setAccessTokenService(WebClient accessTokenService) {
        this.accessTokenService = accessTokenService;
    }

    public void setClientStateManager(ClientCodeStateManager clientStateManager) {
        this.clientStateManager = clientStateManager;
    }

    public void setClientTokenContextManager(ClientTokenContextManager clientTokenContextManager) {
        this.clientTokenContextManager = clientTokenContextManager;
    }

    public OAuthClientUtils.Consumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(OAuthClientUtils.Consumer consumer) {
        this.consumer = consumer;
    }
}

