/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.str;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLKeyInfoProcessor;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.apache.wss4j.dom.message.token.SecurityTokenReference;
import org.apache.wss4j.dom.saml.WSSSAMLKeyInfoProcessor;
import org.apache.wss4j.dom.str.STRParser;
import org.apache.wss4j.dom.str.STRParserUtil;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.w3c.dom.Element;

public class DerivedKeyTokenSTRParser
implements STRParser {
    private byte[] secretKey;

    @Override
    public void parseSecurityTokenReference(Element strElement, RequestData data, WSDocInfo wsDocInfo, Map<String, Object> parameters) throws WSSecurityException {
        WSSecurityEngineResult result;
        Crypto crypto = data.getDecCrypto();
        SecurityTokenReference secRef = new SecurityTokenReference(strElement, data.getBSPEnforcer());
        String uri = null;
        if (secRef.containsReference()) {
            uri = secRef.getReference().getURI();
            if (uri.charAt(0) == '#') {
                uri = uri.substring(1);
            }
        } else if (secRef.containsKeyIdentifier()) {
            uri = secRef.getKeyIdentifierValue();
        }
        if ((result = wsDocInfo.getResult(uri)) != null) {
            this.processPreviousResult(result, secRef, data, wsDocInfo);
        } else if (secRef.containsReference()) {
            this.secretKey = this.getSecretKeyFromToken(uri, null, 6, data);
            if (this.secretKey == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, "unsupportedKeyId", new Object[]{uri});
            }
        } else if (secRef.containsKeyIdentifier()) {
            String keyIdentifierValueType = secRef.getKeyIdentifierValueType();
            if ("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1".equals(keyIdentifierValueType)) {
                this.secretKey = this.getSecretKeyFromToken(secRef.getKeyIdentifierValue(), keyIdentifierValueType, 9, data);
                if (this.secretKey == null) {
                    byte[] keyBytes = secRef.getSKIBytes();
                    List<WSSecurityEngineResult> resultsList = wsDocInfo.getResultsByTag(4096);
                    for (WSSecurityEngineResult bstResult : resultsList) {
                        BinarySecurity bstToken = (BinarySecurity)bstResult.get("binary-security-token");
                        byte[] tokenDigest = WSSecurityUtil.generateDigest(bstToken.getToken());
                        if (!Arrays.equals(tokenDigest, keyBytes)) continue;
                        this.secretKey = (byte[])bstResult.get("secret");
                        break;
                    }
                }
                if (this.secretKey == null) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, "unsupportedKeyId", new Object[]{uri});
                }
            } else {
                X509Certificate[] certs;
                if (keyIdentifierValueType.equals("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1")) {
                    STRParserUtil.checkEncryptedKeyBSPCompliance(secRef, data.getBSPEnforcer());
                }
                if ((certs = secRef.getKeyIdentifier(crypto)) == null || certs.length < 1 || certs[0] == null) {
                    this.secretKey = this.getSecretKeyFromToken(secRef.getKeyIdentifierValue(), keyIdentifierValueType, 9, data);
                    if (this.secretKey == null) {
                        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, "unsupportedKeyId", new Object[]{uri});
                    }
                } else {
                    this.secretKey = crypto.getPrivateKey(certs[0], data.getCallbackHandler()).getEncoded();
                }
            }
        } else {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, "unsupportedKeyId", new Object[0]);
        }
    }

    @Override
    public X509Certificate[] getCertificates() {
        return null;
    }

    @Override
    public Principal getPrincipal() {
        return null;
    }

    @Override
    public PublicKey getPublicKey() {
        return null;
    }

    @Override
    public byte[] getSecretKey() {
        return this.secretKey;
    }

    @Override
    public boolean isTrustedCredential() {
        return false;
    }

    @Override
    public STRParser.REFERENCE_TYPE getCertificatesReferenceType() {
        return null;
    }

    private byte[] getSecretKeyFromToken(String id, String type, int identifier, RequestData data) throws WSSecurityException {
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        WSPasswordCallback pwcb = new WSPasswordCallback(id, null, type, identifier);
        try {
            Callback[] callbacks = new Callback[]{pwcb};
            if (data.getCallbackHandler() != null) {
                data.getCallbackHandler().handle(callbacks);
                return pwcb.getKey();
            }
        }
        catch (Exception e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noPassword", e, new Object[]{id});
        }
        return null;
    }

    private void processPreviousResult(WSSecurityEngineResult result, SecurityTokenReference secRef, RequestData data, WSDocInfo wsDocInfo) throws WSSecurityException {
        int action = (Integer)result.get("action");
        if (8192 == action || 1 == action) {
            STRParserUtil.checkUsernameTokenBSPCompliance(secRef, data.getBSPEnforcer());
            this.secretKey = (byte[])result.get("secret");
        } else if (4 == action) {
            STRParserUtil.checkEncryptedKeyBSPCompliance(secRef, data.getBSPEnforcer());
            this.secretKey = (byte[])result.get("secret");
        } else if (1024 == action || 4096 == action) {
            this.secretKey = (byte[])result.get("secret");
        } else if (8 == action || 16 == action) {
            SamlAssertionWrapper samlAssertion = (SamlAssertionWrapper)result.get("saml-assertion");
            STRParserUtil.checkSamlTokenBSPCompliance(secRef, samlAssertion, data.getBSPEnforcer());
            SAMLKeyInfo keyInfo = SAMLUtil.getCredentialFromSubject((SamlAssertionWrapper)samlAssertion, (SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(data, wsDocInfo), (Crypto)data.getSigVerCrypto(), (CallbackHandler)data.getCallbackHandler());
            this.secretKey = keyInfo.getSecret();
        } else {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, "unsupportedKeyId", new Object[0]);
        }
    }
}

