/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.model;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AbstractToken;
import org.w3c.dom.Element;

public class X509Token
extends AbstractToken {
    private boolean requireKeyIdentifierReference;
    private boolean requireIssuerSerialReference;
    private boolean requireEmbeddedTokenReference;
    private boolean requireThumbprintReference;
    private TokenType tokenType;

    public X509Token(SPConstants.SPVersion version, SPConstants.IncludeTokenType includeTokenType, Element issuer, String issuerName, Element claims, Policy nestedPolicy) {
        super(version, includeTokenType, issuer, issuerName, claims, nestedPolicy);
        this.parseNestedPolicy(nestedPolicy, this);
    }

    public QName getName() {
        return this.getVersion().getSPConstants().getX509Token();
    }

    @Override
    protected AbstractSecurityAssertion cloneAssertion(Policy nestedPolicy) {
        return new X509Token(this.getVersion(), this.getIncludeTokenType(), this.getIssuer(), this.getIssuerName(), this.getClaims(), nestedPolicy);
    }

    protected void parseNestedPolicy(Policy nestedPolicy, X509Token x509Token) {
        Iterator alternatives = nestedPolicy.getAlternatives();
        if (alternatives.hasNext()) {
            List assertions = (List)alternatives.next();
            for (int i = 0; i < assertions.size(); ++i) {
                Assertion assertion = (Assertion)assertions.get(i);
                String assertionName = assertion.getName().getLocalPart();
                String assertionNamespace = assertion.getName().getNamespaceURI();
                AbstractToken.DerivedKeys derivedKeys = AbstractToken.DerivedKeys.lookUp(assertionName);
                if (derivedKeys != null) {
                    if (x509Token.getDerivedKeys() != null) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    x509Token.setDerivedKeys(derivedKeys);
                    continue;
                }
                TokenType tokenType = TokenType.lookUp(assertionName);
                if (tokenType != null) {
                    if (x509Token.getTokenType() != null) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    x509Token.setTokenType(tokenType);
                    continue;
                }
                if (this.getVersion().getSPConstants().getRequireKeyIdentifierReference().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getRequireKeyIdentifierReference().getNamespaceURI().equals(assertionNamespace)) {
                    if (x509Token.isRequireKeyIdentifierReference()) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    x509Token.setRequireKeyIdentifierReference(true);
                    continue;
                }
                if (this.getVersion().getSPConstants().getRequireIssuerSerialReference().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getRequireIssuerSerialReference().getNamespaceURI().equals(assertionNamespace)) {
                    if (x509Token.isRequireIssuerSerialReference()) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    x509Token.setRequireIssuerSerialReference(true);
                    continue;
                }
                if (this.getVersion().getSPConstants().getRequireEmbeddedTokenReference().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getRequireEmbeddedTokenReference().getNamespaceURI().equals(assertionNamespace)) {
                    if (x509Token.isRequireEmbeddedTokenReference()) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    x509Token.setRequireEmbeddedTokenReference(true);
                    continue;
                }
                if (!this.getVersion().getSPConstants().getRequireThumbprintReference().getLocalPart().equals(assertionName) || !this.getVersion().getSPConstants().getRequireThumbprintReference().getNamespaceURI().equals(assertionNamespace)) continue;
                if (x509Token.isRequireThumbprintReference()) {
                    throw new IllegalArgumentException("Invalid Policy");
                }
                x509Token.setRequireThumbprintReference(true);
            }
        }
    }

    public boolean isRequireKeyIdentifierReference() {
        return this.requireKeyIdentifierReference;
    }

    protected void setRequireKeyIdentifierReference(boolean requireKeyIdentifierReference) {
        this.requireKeyIdentifierReference = requireKeyIdentifierReference;
    }

    public boolean isRequireIssuerSerialReference() {
        return this.requireIssuerSerialReference;
    }

    protected void setRequireIssuerSerialReference(boolean requireIssuerSerialReference) {
        this.requireIssuerSerialReference = requireIssuerSerialReference;
    }

    public boolean isRequireEmbeddedTokenReference() {
        return this.requireEmbeddedTokenReference;
    }

    protected void setRequireEmbeddedTokenReference(boolean requireEmbeddedTokenReference) {
        this.requireEmbeddedTokenReference = requireEmbeddedTokenReference;
    }

    public boolean isRequireThumbprintReference() {
        return this.requireThumbprintReference;
    }

    protected void setRequireThumbprintReference(boolean requireThumbprintReference) {
        this.requireThumbprintReference = requireThumbprintReference;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    protected void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public static enum TokenType {
        WssX509V3Token10,
        WssX509Pkcs7Token10,
        WssX509PkiPathV1Token10,
        WssX509V1Token11,
        WssX509V3Token11,
        WssX509Pkcs7Token11,
        WssX509PkiPathV1Token11;

        private static final Map<String, TokenType> lookup;

        public static TokenType lookUp(String name) {
            return lookup.get(name);
        }

        static {
            lookup = new HashMap<String, TokenType>();
            for (TokenType u : EnumSet.allOf(TokenType.class)) {
                lookup.put(u.name(), u);
            }
        }
    }
}

