/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.util.Collections;
import java.util.List;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class ServerAuthorizationCodeGrant
extends AuthorizationCodeGrant {
    private static final long serialVersionUID = -5004608901535459036L;
    private long issuedAt;
    private long expiresIn;
    private Client client;
    private List<String> approvedScopes = Collections.emptyList();
    private List<String> requestedScopes = Collections.emptyList();
    private UserSubject subject;
    private String audience;
    private String clientCodeChallenge;

    public ServerAuthorizationCodeGrant() {
    }

    public ServerAuthorizationCodeGrant(Client client, long lifetime) {
        this(client, OAuthUtils.generateRandomTokenKey(), lifetime, OAuthUtils.getIssuedAt());
    }

    public ServerAuthorizationCodeGrant(Client client, String code, long expiresIn, long issuedAt) {
        super(code);
        this.client = client;
        this.expiresIn = expiresIn;
        this.issuedAt = issuedAt;
    }

    public long getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(long issuedAt) {
        this.issuedAt = issuedAt;
    }

    @Deprecated
    public long getLifetime() {
        return this.expiresIn;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client c) {
        this.client = c;
    }

    public void setApprovedScopes(List<String> scopes) {
        this.approvedScopes = scopes;
    }

    public List<String> getApprovedScopes() {
        return this.approvedScopes;
    }

    public void setSubject(UserSubject subject) {
        this.subject = subject;
    }

    public UserSubject getSubject() {
        return this.subject;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getClientCodeChallenge() {
        return this.clientCodeChallenge;
    }

    public void setClientCodeChallenge(String clientCodeChallenge) {
        this.clientCodeChallenge = clientCodeChallenge;
    }

    public List<String> getRequestedScopes() {
        return this.requestedScopes;
    }

    public void setRequestedScopes(List<String> requestedScopes) {
        this.requestedScopes = requestedScopes;
    }
}

