/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.AbstractWrappedOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.local.LocalConduit;
import org.apache.cxf.transport.local.LocalTransportFactory;
import org.apache.cxf.workqueue.SynchronousExecutor;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class LocalDestination
extends AbstractDestination {
    private static final Logger LOG = LogUtils.getL7dLogger(LocalDestination.class);
    private LocalTransportFactory localDestinationFactory;

    public LocalDestination(LocalTransportFactory localDestinationFactory, EndpointReferenceType epr, EndpointInfo ei, Bus bus) {
        super(bus, epr, ei);
        this.localDestinationFactory = localDestinationFactory;
    }

    public void shutdown() {
        this.localDestinationFactory.remove(this);
    }

    public Bus getBus() {
        return this.bus;
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        Conduit conduit = (Conduit)inMessage.get((Object)LocalConduit.IN_CONDUIT);
        if (conduit instanceof LocalConduit) {
            return new SynchronousConduit((LocalConduit)conduit);
        }
        return null;
    }

    class SynchronousConduit
    extends AbstractConduit {
        private LocalConduit conduit;

        public SynchronousConduit(LocalConduit conduit) {
            super(null);
            this.conduit = conduit;
        }

        public void prepare(Message message) throws IOException {
            if (!Boolean.TRUE.equals(message.getExchange().get((Object)LocalConduit.DIRECT_DISPATCH))) {
                Exchange exchange = (Exchange)message.getExchange().get((Object)LocalConduit.IN_EXCHANGE);
                LocalDestinationOutputStream cout = new LocalDestinationOutputStream(exchange, message);
                message.setContent(OutputStream.class, (Object)cout);
            } else {
                CachedOutputStream stream = new CachedOutputStream();
                message.setContent(OutputStream.class, (Object)stream);
                message.setContent(CachedOutputStream.class, (Object)stream);
                stream.holdTempFile();
            }
        }

        public void close(Message message) throws IOException {
            Integer i = (Integer)message.get((Object)Message.RESPONSE_CODE);
            if (i == null) {
                int code = message.getExchange().isOneWay() && !MessageUtils.isPartialResponse((Message)message) || MessageUtils.isEmptyPartialResponse((Message)message) ? 202 : 200;
                message.put((Object)Message.RESPONSE_CODE, (Object)code);
            }
            if (Boolean.TRUE.equals(message.getExchange().get((Object)LocalConduit.DIRECT_DISPATCH))) {
                Exchange exchange = (Exchange)message.getExchange().get((Object)LocalConduit.IN_EXCHANGE);
                MessageImpl copy = new MessageImpl();
                copy.putAll((Map)message);
                ((OutputStream)message.getContent(OutputStream.class)).close();
                CachedOutputStream stream = (CachedOutputStream)message.getContent(CachedOutputStream.class);
                message.setContent(OutputStream.class, (Object)stream);
                MessageImpl.copyContent((Message)message, (Message)copy);
                copy.setContent(InputStream.class, (Object)stream.getInputStream());
                stream.releaseTempFileHold();
                if (exchange != null && exchange.getInMessage() == null) {
                    exchange.setInMessage((Message)copy);
                }
                this.conduit.getMessageObserver().onMessage((Message)copy);
                return;
            }
            super.close(message);
        }

        protected Logger getLogger() {
            return LOG;
        }

        private final class LocalDestinationOutputStream
        extends AbstractWrappedOutputStream {
            private final Exchange exchange;
            private final Message message;

            private LocalDestinationOutputStream(Exchange exchange, Message message) {
                this.exchange = exchange;
                this.message = message;
            }

            public void close() throws IOException {
                if (!this.written) {
                    this.dispatchToClient(true);
                }
                super.close();
            }

            protected void onFirstWrite() throws IOException {
                this.dispatchToClient(false);
            }

            protected void dispatchToClient(boolean empty) throws IOException {
                Executor ex;
                final MessageImpl m = new MessageImpl();
                LocalDestination.this.localDestinationFactory.copy(this.message, (Message)m);
                if (!empty) {
                    PipedInputStream stream = new PipedInputStream();
                    this.wrappedStream = new PipedOutputStream(stream);
                    m.setContent(InputStream.class, (Object)stream);
                }
                Runnable receiver = new Runnable(){

                    @Override
                    public void run() {
                        if (LocalDestinationOutputStream.this.exchange != null) {
                            LocalDestinationOutputStream.this.exchange.setInMessage((Message)m);
                        }
                        SynchronousConduit.this.conduit.getMessageObserver().onMessage((Message)m);
                    }
                };
                Executor executor = ex = this.message.getExchange() != null ? (Executor)this.message.getExchange().get(Executor.class) : null;
                if (ex == null || SynchronousExecutor.isA((Executor)ex)) {
                    ex = this.exchange == null ? LocalDestination.this.localDestinationFactory.getExecutor(LocalDestination.this.bus) : LocalDestination.this.localDestinationFactory.getExecutor(this.exchange.getBus());
                    if (ex != null) {
                        ex.execute(receiver);
                    } else {
                        new Thread(receiver).start();
                    }
                } else {
                    ex.execute(receiver);
                }
            }
        }
    }
}

