/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.common.util.Base64UrlOutputStream;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJwsWriterProvider;
import org.apache.cxf.rs.security.jose.jws.JwsCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsOutputStream;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;

@Priority(value=1002)
public class JwsWriterInterceptor
extends AbstractJwsWriterProvider
implements WriterInterceptor {
    private boolean contentTypeRequired = true;
    private boolean useJwsOutputStream;
    private JoseHeadersReaderWriter writer = new JoseHeadersReaderWriter();

    public void aroundWriteTo(WriterInterceptorContext ctx) throws IOException, WebApplicationException {
        if (ctx.getEntity() == null) {
            ctx.proceed();
            return;
        }
        JoseHeaders headers = new JoseHeaders();
        JwsSignatureProvider sigProvider = this.getInitializedSigProvider(headers);
        this.setContentTypeIfNeeded(headers, ctx);
        OutputStream actualOs = ctx.getOutputStream();
        if (this.useJwsOutputStream) {
            JwsSignature jwsSignature = sigProvider.createJwsSignature(headers);
            JwsOutputStream jwsStream = new JwsOutputStream(actualOs, jwsSignature);
            byte[] headerBytes = StringUtils.toBytesUTF8((String)this.writer.headersToJson(headers));
            Base64UrlUtility.encodeAndStream((byte[])headerBytes, (int)0, (int)headerBytes.length, (OutputStream)jwsStream);
            jwsStream.write(new byte[]{46});
            Base64UrlOutputStream base64Stream = new Base64UrlOutputStream((OutputStream)jwsStream);
            ctx.setOutputStream((OutputStream)base64Stream);
            ctx.proceed();
            this.setJoseMediaType(ctx);
            base64Stream.flush();
            jwsStream.flush();
        } else {
            CachedOutputStream cos = new CachedOutputStream();
            ctx.setOutputStream((OutputStream)cos);
            ctx.proceed();
            JwsCompactProducer p = new JwsCompactProducer(headers, new String(cos.getBytes(), "UTF-8"));
            this.setJoseMediaType(ctx);
            this.writeJws(p, sigProvider, actualOs);
        }
    }

    public void setContentTypeRequired(boolean contentTypeRequired) {
        this.contentTypeRequired = contentTypeRequired;
    }

    public void setUseJwsOutputStream(boolean useJwsOutputStream) {
        this.useJwsOutputStream = useJwsOutputStream;
    }

    private void setContentTypeIfNeeded(JoseHeaders headers, WriterInterceptorContext ctx) {
        MediaType mt;
        if (this.contentTypeRequired && (mt = ctx.getMediaType()) != null && !JAXRSUtils.mediaTypeToString((MediaType)mt, (String[])new String[0]).equals("application/jose")) {
            if ("application".equals(mt.getType())) {
                headers.setContentType(mt.getSubtype());
            } else {
                headers.setContentType(JAXRSUtils.mediaTypeToString((MediaType)mt, (String[])new String[0]));
            }
        }
    }

    private void setJoseMediaType(WriterInterceptorContext ctx) {
        MediaType joseMediaType = JAXRSUtils.toMediaType((String)"application/jose");
        ctx.setMediaType(joseMediaType);
    }
}

