/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.spec.AlgorithmParameterSpec;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionCipherProperties;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;

public abstract class AbstractContentEncryptionCipherProperties
implements ContentEncryptionCipherProperties {
    private static final int DEFAULT_AUTH_TAG_LENGTH = 128;
    private int authTagLen = 128;
    private String algo;

    public AbstractContentEncryptionCipherProperties(String algo) {
        this.algo = algo;
    }

    @Override
    public AlgorithmParameterSpec getAlgorithmParameterSpec(byte[] theIv) {
        return CryptoUtils.getContentEncryptionCipherSpec((int)this.getAuthTagLen(), (byte[])theIv);
    }

    @Override
    public byte[] getAdditionalAuthenticationData(String headersJson, byte[] aad) {
        return JweUtils.getAdditionalAuthenticationData(headersJson, aad);
    }

    protected int getAuthTagLen() {
        return this.authTagLen;
    }

    @Override
    public String getAlgorithm() {
        return this.algo;
    }
}

