/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.crypto.MessageDigestUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.KeyManagementUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.AesGcmContentDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesGcmContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesGcmWrapKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesGcmWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesWrapKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.ContentDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.DirectKeyJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.DirectKeyJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.RSAKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.RSAKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.WrappedKeyJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.WrappedKeyJweEncryption;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;

public final class JweUtils {
    private static final String JSON_WEB_ENCRYPTION_CEK_ALGO_PROP = "rs.security.jwe.content.encryption.algorithm";
    private static final String JSON_WEB_ENCRYPTION_KEY_ALGO_PROP = "rs.security.jwe.key.encryption.algorithm";
    private static final String JSON_WEB_ENCRYPTION_ZIP_ALGO_PROP = "rs.security.jwe.zip.algorithm";
    private static final String RSSEC_ENCRYPTION_OUT_PROPS = "rs.security.encryption.out.properties";
    private static final String RSSEC_ENCRYPTION_IN_PROPS = "rs.security.encryption.in.properties";
    private static final String RSSEC_ENCRYPTION_PROPS = "rs.security.encryption.properties";
    private static final String RSSEC_ENCRYPTION_REPORT_KEY_PROP = "rs.security.jwe.report.public.key";

    private JweUtils() {
    }

    public static String encrypt(RSAPublicKey key, String keyAlgo, String contentAlgo, byte[] content) {
        return JweUtils.encrypt(key, keyAlgo, contentAlgo, content, null);
    }

    public static String encrypt(RSAPublicKey key, String keyAlgo, String contentAlgo, byte[] content, String ct) {
        KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getRSAKeyEncryptionAlgorithm(key, keyAlgo);
        return JweUtils.encrypt(keyEncryptionProvider, contentAlgo, content, ct);
    }

    public static String encrypt(SecretKey key, String keyAlgo, String contentAlgo, byte[] content) {
        return JweUtils.encrypt(key, keyAlgo, contentAlgo, content, null);
    }

    public static String encrypt(SecretKey key, String keyAlgo, String contentAlgo, byte[] content, String ct) {
        if (keyAlgo != null) {
            KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getSecretKeyEncryptionAlgorithm(key, keyAlgo);
            return JweUtils.encrypt(keyEncryptionProvider, contentAlgo, content, ct);
        }
        return JweUtils.encryptDirect(key, contentAlgo, content, ct);
    }

    public static String encrypt(JsonWebKey key, String contentAlgo, byte[] content, String ct) {
        KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getKeyEncryptionAlgorithm(key);
        return JweUtils.encrypt(keyEncryptionProvider, contentAlgo, content, ct);
    }

    public static String encryptDirect(SecretKey key, String contentAlgo, byte[] content) {
        return JweUtils.encryptDirect(key, contentAlgo, content, null);
    }

    public static String encryptDirect(SecretKey key, String contentAlgo, byte[] content, String ct) {
        DirectKeyJweEncryption jwe = JweUtils.getDirectKeyJweEncryption(key, contentAlgo);
        return jwe.encrypt(content, JweUtils.toJweHeaders(ct));
    }

    public static String encryptDirect(JsonWebKey key, byte[] content, String ct) {
        DirectKeyJweEncryption jwe = JweUtils.getDirectKeyJweEncryption(key);
        return jwe.encrypt(content, JweUtils.toJweHeaders(ct));
    }

    public static byte[] decrypt(RSAPrivateKey key, String keyAlgo, String contentAlgo, String content) {
        KeyDecryptionAlgorithm keyDecryptionProvider = JweUtils.getRSAKeyDecryptionAlgorithm(key, keyAlgo);
        return JweUtils.decrypt(keyDecryptionProvider, contentAlgo, content);
    }

    public static byte[] decrypt(SecretKey key, String keyAlgo, String contentAlgo, String content) {
        if (keyAlgo != null) {
            KeyDecryptionAlgorithm keyDecryptionProvider = JweUtils.getSecretKeyDecryptionAlgorithm(key, keyAlgo);
            return JweUtils.decrypt(keyDecryptionProvider, contentAlgo, content);
        }
        return JweUtils.decryptDirect(key, contentAlgo, content);
    }

    public static byte[] decrypt(JsonWebKey key, String contentAlgo, String content) {
        KeyDecryptionAlgorithm keyDecryptionProvider = JweUtils.getKeyDecryptionAlgorithm(key);
        return JweUtils.decrypt(keyDecryptionProvider, contentAlgo, content);
    }

    public static byte[] decryptDirect(SecretKey key, String contentAlgo, String content) {
        DirectKeyJweDecryption jwe = JweUtils.getDirectKeyJweDecryption(key, contentAlgo);
        return jwe.decrypt(content).getContent();
    }

    public static byte[] decryptDirect(JsonWebKey key, String content) {
        DirectKeyJweDecryption jwe = JweUtils.getDirectKeyJweDecryption(key);
        return jwe.decrypt(content).getContent();
    }

    public static KeyEncryptionAlgorithm getKeyEncryptionAlgorithm(JsonWebKey jwk) {
        return JweUtils.getKeyEncryptionAlgorithm(jwk, null);
    }

    public static KeyEncryptionAlgorithm getKeyEncryptionAlgorithm(JsonWebKey jwk, String defaultAlgorithm) {
        String keyEncryptionAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        KeyEncryptionAlgorithm keyEncryptionProvider = null;
        if ("RSA".equals(jwk.getKeyType())) {
            keyEncryptionProvider = JweUtils.getRSAKeyEncryptionAlgorithm(JwkUtils.toRSAPublicKey(jwk, true), keyEncryptionAlgo);
        } else if ("oct".equals(jwk.getKeyType())) {
            keyEncryptionProvider = JweUtils.getSecretKeyEncryptionAlgorithm(JwkUtils.toSecretKey(jwk), keyEncryptionAlgo);
        }
        return keyEncryptionProvider;
    }

    public static KeyEncryptionAlgorithm getRSAKeyEncryptionAlgorithm(RSAPublicKey key, String algo) {
        return new RSAKeyEncryptionAlgorithm(key, algo);
    }

    public static KeyEncryptionAlgorithm getSecretKeyEncryptionAlgorithm(SecretKey key, String algo) {
        if (Algorithm.isAesKeyWrap(algo)) {
            return new AesWrapKeyEncryptionAlgorithm(key, algo);
        }
        if (Algorithm.isAesGcmKeyWrap(algo)) {
            return new AesGcmWrapKeyEncryptionAlgorithm(key, algo);
        }
        return null;
    }

    public static KeyDecryptionAlgorithm getKeyDecryptionAlgorithm(JsonWebKey jwk) {
        return JweUtils.getKeyDecryptionAlgorithm(jwk, null);
    }

    public static KeyDecryptionAlgorithm getKeyDecryptionAlgorithm(JsonWebKey jwk, String defaultAlgorithm) {
        String keyEncryptionAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        KeyDecryptionAlgorithm keyDecryptionProvider = null;
        if ("RSA".equals(jwk.getKeyType())) {
            keyDecryptionProvider = JweUtils.getRSAKeyDecryptionAlgorithm(JwkUtils.toRSAPrivateKey(jwk), keyEncryptionAlgo);
        } else if ("oct".equals(jwk.getKeyType())) {
            keyDecryptionProvider = JweUtils.getSecretKeyDecryptionAlgorithm(JwkUtils.toSecretKey(jwk), keyEncryptionAlgo);
        }
        return keyDecryptionProvider;
    }

    public static KeyDecryptionAlgorithm getRSAKeyDecryptionAlgorithm(RSAPrivateKey key, String algo) {
        return new RSAKeyDecryptionAlgorithm(key, algo);
    }

    public static KeyDecryptionAlgorithm getSecretKeyDecryptionAlgorithm(SecretKey key, String algo) {
        if (Algorithm.isAesKeyWrap(algo)) {
            return new AesWrapKeyDecryptionAlgorithm(key, algo);
        }
        if (Algorithm.isAesGcmKeyWrap(algo)) {
            return new AesGcmWrapKeyDecryptionAlgorithm(key, algo);
        }
        return null;
    }

    public static ContentEncryptionAlgorithm getContentEncryptionAlgorithm(JsonWebKey jwk) {
        return JweUtils.getContentEncryptionAlgorithm(jwk, null);
    }

    public static ContentEncryptionAlgorithm getContentEncryptionAlgorithm(JsonWebKey jwk, String defaultAlgorithm) {
        String ctEncryptionAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        ContentEncryptionAlgorithm contentEncryptionProvider = null;
        if ("oct".equals(jwk.getKeyType())) {
            return JweUtils.getContentEncryptionAlgorithm(JwkUtils.toSecretKey(jwk), ctEncryptionAlgo);
        }
        return contentEncryptionProvider;
    }

    public static ContentEncryptionAlgorithm getContentEncryptionAlgorithm(SecretKey key, String algorithm) {
        if (Algorithm.isAesGcm(algorithm)) {
            return new AesGcmContentEncryptionAlgorithm(key, null, algorithm);
        }
        return null;
    }

    public static ContentEncryptionAlgorithm getContentEncryptionAlgorithm(String algorithm) {
        if (Algorithm.isAesGcm(algorithm)) {
            return new AesGcmContentEncryptionAlgorithm(algorithm);
        }
        return null;
    }

    public static ContentDecryptionAlgorithm getContentDecryptionAlgorithm(String algorithm) {
        if (Algorithm.isAesGcm(algorithm)) {
            return new AesGcmContentDecryptionAlgorithm(algorithm);
        }
        return null;
    }

    public static SecretKey getContentDecryptionSecretKey(JsonWebKey jwk) {
        return JweUtils.getContentDecryptionSecretKey(jwk, null);
    }

    public static SecretKey getContentDecryptionSecretKey(JsonWebKey jwk, String defaultAlgorithm) {
        String ctEncryptionAlgo;
        String string = ctEncryptionAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        if ("oct".equals(jwk.getKeyType()) && Algorithm.isAesGcm(ctEncryptionAlgo)) {
            return JwkUtils.toSecretKey(jwk);
        }
        return null;
    }

    public static DirectKeyJweEncryption getDirectKeyJweEncryption(JsonWebKey key) {
        return new DirectKeyJweEncryption(JweUtils.getContentEncryptionAlgorithm(key, key.getAlgorithm()));
    }

    public static DirectKeyJweEncryption getDirectKeyJweEncryption(SecretKey key, String algorithm) {
        return new DirectKeyJweEncryption(JweUtils.getContentEncryptionAlgorithm(key, algorithm));
    }

    public static DirectKeyJweDecryption getDirectKeyJweDecryption(SecretKey key, String algorithm) {
        return new DirectKeyJweDecryption(key, JweUtils.getContentDecryptionAlgorithm(algorithm));
    }

    public static DirectKeyJweDecryption getDirectKeyJweDecryption(JsonWebKey key) {
        return new DirectKeyJweDecryption(JwkUtils.toSecretKey(key), JweUtils.getContentDecryptionAlgorithm(key.getAlgorithm()));
    }

    public static JweEncryptionProvider loadEncryptionProvider(boolean required) {
        return JweUtils.loadEncryptionProvider(null, required);
    }

    public static JweEncryptionProvider loadEncryptionProvider(JweHeaders headers, boolean required) {
        Message m = JAXRSUtils.getCurrentMessage();
        Properties props = KeyManagementUtils.loadStoreProperties(m, required, RSSEC_ENCRYPTION_OUT_PROPS, RSSEC_ENCRYPTION_PROPS);
        if (props == null) {
            return null;
        }
        boolean reportPublicKey = headers != null && MessageUtils.isTrue((Object)MessageUtils.getContextualProperty((Message)m, (String)RSSEC_ENCRYPTION_REPORT_KEY_PROP, (String)"rs.security.report.public.key"));
        KeyEncryptionAlgorithm keyEncryptionProvider = null;
        String keyEncryptionAlgo = JweUtils.getKeyEncryptionAlgo(m, props, null, null);
        String contentEncryptionAlgo = JweUtils.getContentEncryptionAlgo(m, props, null);
        ContentEncryptionAlgorithm ctEncryptionProvider = null;
        if ("jwk".equals(props.get("rs.security.keystore.type"))) {
            JsonWebKey jwk = JwkUtils.loadJsonWebKey(m, props, "encrypt");
            keyEncryptionAlgo = JweUtils.getKeyEncryptionAlgo(m, props, jwk.getAlgorithm(), JweUtils.getDefaultKeyAlgo(jwk));
            if ("direct".equals(keyEncryptionAlgo)) {
                contentEncryptionAlgo = JweUtils.getContentEncryptionAlgo(m, props, jwk.getAlgorithm());
                ctEncryptionProvider = JweUtils.getContentEncryptionAlgorithm(jwk, contentEncryptionAlgo);
            } else {
                keyEncryptionProvider = JweUtils.getKeyEncryptionAlgorithm(jwk, keyEncryptionAlgo);
                if (reportPublicKey) {
                    JwkUtils.setPublicKeyInfo(jwk, headers, keyEncryptionAlgo);
                }
            }
        } else {
            keyEncryptionProvider = JweUtils.getRSAKeyEncryptionAlgorithm((RSAPublicKey)KeyManagementUtils.loadPublicKey(m, props), keyEncryptionAlgo);
            if (reportPublicKey) {
                headers.setX509Chain(KeyManagementUtils.loadAndEncodeX509CertificateOrChain(m, props));
            }
        }
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, ctEncryptionProvider, contentEncryptionAlgo, props.getProperty(JSON_WEB_ENCRYPTION_ZIP_ALGO_PROP));
    }

    public static JweDecryptionProvider loadDecryptionProvider(boolean required) {
        return JweUtils.loadDecryptionProvider(null, required);
    }

    public static JweDecryptionProvider loadDecryptionProvider(JweHeaders inHeaders, boolean required) {
        Message m = JAXRSUtils.getCurrentMessage();
        Properties props = KeyManagementUtils.loadStoreProperties(m, required, RSSEC_ENCRYPTION_IN_PROPS, RSSEC_ENCRYPTION_PROPS);
        if (props == null) {
            return null;
        }
        KeyDecryptionAlgorithm keyDecryptionProvider = null;
        String contentEncryptionAlgo = JweUtils.getContentEncryptionAlgo(m, props, null);
        SecretKey ctDecryptionKey = null;
        String keyEncryptionAlgo = JweUtils.getKeyEncryptionAlgo(m, props, null, null);
        if (inHeaders != null && inHeaders.getHeader("x5c") != null) {
            List<X509Certificate> chain = KeyManagementUtils.toX509CertificateChain(inHeaders.getX509Chain());
            RSAPrivateKey privateKey = KeyManagementUtils.loadPrivateKey(m, props, chain, "decrypt");
            contentEncryptionAlgo = inHeaders.getContentEncryptionAlgorithm();
            keyDecryptionProvider = JweUtils.getRSAKeyDecryptionAlgorithm(privateKey, inHeaders.getKeyEncryptionAlgorithm());
        } else if ("jwk".equals(props.get("rs.security.keystore.type"))) {
            JsonWebKey jwk = JwkUtils.loadJsonWebKey(m, props, "decrypt");
            keyEncryptionAlgo = JweUtils.getKeyEncryptionAlgo(m, props, jwk.getAlgorithm(), JweUtils.getDefaultKeyAlgo(jwk));
            if ("direct".equals(keyEncryptionAlgo)) {
                contentEncryptionAlgo = JweUtils.getContentEncryptionAlgo(m, props, contentEncryptionAlgo);
                ctDecryptionKey = JweUtils.getContentDecryptionSecretKey(jwk, contentEncryptionAlgo);
            } else {
                keyDecryptionProvider = JweUtils.getKeyDecryptionAlgorithm(jwk, keyEncryptionAlgo);
            }
        } else {
            keyDecryptionProvider = JweUtils.getRSAKeyDecryptionAlgorithm(KeyManagementUtils.loadPrivateKey(m, props, "decrypt"), keyEncryptionAlgo);
        }
        return JweUtils.createJweDecryptionProvider(keyDecryptionProvider, ctDecryptionKey, contentEncryptionAlgo);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(RSAPublicKey key, String keyAlgo, String contentEncryptionAlgo, String compression) {
        KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getRSAKeyEncryptionAlgorithm(key, keyAlgo);
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, contentEncryptionAlgo, compression);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(RSAPublicKey key, JweHeaders headers) {
        KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getRSAKeyEncryptionAlgorithm(key, headers.getKeyEncryptionAlgorithm());
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, headers);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(SecretKey key, String keyAlgo, String contentEncryptionAlgo, String compression) {
        KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getSecretKeyEncryptionAlgorithm(key, keyAlgo);
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, contentEncryptionAlgo, compression);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(SecretKey key, JweHeaders headers) {
        KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getSecretKeyEncryptionAlgorithm(key, headers.getKeyEncryptionAlgorithm());
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, headers);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(JsonWebKey key, String contentEncryptionAlgo, String compression) {
        KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getKeyEncryptionAlgorithm(key);
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, contentEncryptionAlgo, compression);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(JsonWebKey key, JweHeaders headers) {
        KeyEncryptionAlgorithm keyEncryptionProvider = JweUtils.getKeyEncryptionAlgorithm(key);
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, headers);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(KeyEncryptionAlgorithm keyEncryptionProvider, String contentEncryptionAlgo, String compression) {
        JweHeaders headers = JweUtils.prepareJweHeaders(keyEncryptionProvider != null ? keyEncryptionProvider.getAlgorithm() : null, contentEncryptionAlgo, compression);
        return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, headers);
    }

    public static JweEncryptionProvider createJweEncryptionProvider(KeyEncryptionAlgorithm keyEncryptionProvider, JweHeaders headers) {
        String contentEncryptionAlgo = headers.getContentEncryptionAlgorithm();
        if (Algorithm.isAesCbcHmac(contentEncryptionAlgo)) {
            return new AesCbcHmacJweEncryption(contentEncryptionAlgo, keyEncryptionProvider);
        }
        return new WrappedKeyJweEncryption(keyEncryptionProvider, JweUtils.getContentEncryptionAlgorithm(contentEncryptionAlgo));
    }

    public static JweDecryptionProvider createJweDecryptionProvider(RSAPrivateKey key, String keyAlgo, String contentDecryptionAlgo) {
        return JweUtils.createJweDecryptionProvider(JweUtils.getRSAKeyDecryptionAlgorithm(key, keyAlgo), contentDecryptionAlgo);
    }

    public static JweDecryptionProvider createJweDecryptionProvider(SecretKey key, String keyAlgo, String contentDecryptionAlgo) {
        return JweUtils.createJweDecryptionProvider(JweUtils.getSecretKeyDecryptionAlgorithm(key, keyAlgo), contentDecryptionAlgo);
    }

    public static JweDecryptionProvider createJweDecryptionProvider(JsonWebKey key, String contentDecryptionAlgo) {
        return JweUtils.createJweDecryptionProvider(JweUtils.getKeyDecryptionAlgorithm(key), contentDecryptionAlgo);
    }

    public static JweDecryptionProvider createJweDecryptionProvider(KeyDecryptionAlgorithm keyDecryptionProvider, String contentDecryptionAlgo) {
        if (Algorithm.isAesCbcHmac(contentDecryptionAlgo)) {
            return new AesCbcHmacJweDecryption(keyDecryptionProvider, contentDecryptionAlgo);
        }
        return new WrappedKeyJweDecryption(keyDecryptionProvider, JweUtils.getContentDecryptionAlgorithm(contentDecryptionAlgo));
    }

    public static boolean validateCriticalHeaders(JoseHeaders headers) {
        return JoseUtils.validateCriticalHeaders(headers);
    }

    public static byte[] getECDHKey(JsonWebKey privateKey, JsonWebKey peerPublicKey, byte[] partyUInfo, byte[] partyVInfo, String algoName, int algoKeyBitLen) {
        return JweUtils.getECDHKey(JwkUtils.toECPrivateKey(privateKey), JwkUtils.toECPublicKey(peerPublicKey), partyUInfo, partyVInfo, algoName, algoKeyBitLen);
    }

    public static byte[] getECDHKey(ECPrivateKey privateKey, ECPublicKey peerPublicKey, byte[] partyUInfo, byte[] partyVInfo, String algoName, int algoKeyBitLen) {
        byte[] keyZ = JweUtils.generateKeyZ(privateKey, peerPublicKey);
        return JweUtils.calculateDerivedKey(keyZ, algoName, partyUInfo, partyVInfo, algoKeyBitLen);
    }

    public static byte[] getAdditionalAuthenticationData(String headersJson, byte[] aad) {
        byte[] headersAAD = JweHeaders.toCipherAdditionalAuthData(headersJson);
        if (aad != null) {
            byte[] newAAD = Arrays.copyOf(headersAAD, headersAAD.length + 1 + aad.length);
            newAAD[headersAAD.length] = 46;
            System.arraycopy(aad, 0, newAAD, headersAAD.length + 1, aad.length);
            return newAAD;
        }
        return headersAAD;
    }

    private static byte[] calculateDerivedKey(byte[] keyZ, String algoName, byte[] apuBytes, byte[] apvBytes, int algoKeyBitLen) {
        byte[] emptyPartyInfo = new byte[4];
        if (apuBytes != null && apvBytes != null && Arrays.equals(apuBytes, apvBytes)) {
            throw new SecurityException();
        }
        byte[] algorithmId = JweUtils.concatenateDatalenAndData(StringUtils.toBytesASCII((String)algoName));
        byte[] partyUInfo = apuBytes == null ? emptyPartyInfo : JweUtils.concatenateDatalenAndData(apuBytes);
        byte[] partyVInfo = apvBytes == null ? emptyPartyInfo : JweUtils.concatenateDatalenAndData(apvBytes);
        byte[] suppPubInfo = JweUtils.datalenToBytes(algoKeyBitLen);
        byte[] otherInfo = new byte[algorithmId.length + partyUInfo.length + partyVInfo.length + suppPubInfo.length];
        System.arraycopy(algorithmId, 0, otherInfo, 0, algorithmId.length);
        System.arraycopy(partyUInfo, 0, otherInfo, algorithmId.length, partyUInfo.length);
        System.arraycopy(partyVInfo, 0, otherInfo, algorithmId.length + partyUInfo.length, partyVInfo.length);
        System.arraycopy(suppPubInfo, 0, otherInfo, algorithmId.length + partyUInfo.length + partyVInfo.length, suppPubInfo.length);
        byte[] concatKDF = new byte[36 + otherInfo.length];
        concatKDF[3] = 1;
        System.arraycopy(keyZ, 0, concatKDF, 4, keyZ.length);
        System.arraycopy(otherInfo, 0, concatKDF, 36, otherInfo.length);
        try {
            byte[] round1Hash = MessageDigestUtils.createDigest((byte[])concatKDF, (String)"SHA-256");
            return Arrays.copyOf(round1Hash, algoKeyBitLen / 8);
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    private static byte[] generateKeyZ(ECPrivateKey privateKey, ECPublicKey publicKey) {
        try {
            KeyAgreement ka = KeyAgreement.getInstance("ECDH");
            ka.init(privateKey);
            ka.doPhase(publicKey, true);
            return ka.generateSecret();
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    private static byte[] concatenateDatalenAndData(byte[] bytesASCII) {
        byte[] datalen = JweUtils.datalenToBytes(bytesASCII.length);
        byte[] all = new byte[4 + bytesASCII.length];
        System.arraycopy(datalen, 0, all, 0, 4);
        System.arraycopy(bytesASCII, 0, all, 4, bytesASCII.length);
        return all;
    }

    private static byte[] datalenToBytes(int len) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        return buf.putInt(len).array();
    }

    private static JweHeaders prepareJweHeaders(String keyEncryptionAlgo, String contentEncryptionAlgo, String compression) {
        JweHeaders headers = new JweHeaders();
        if (keyEncryptionAlgo != null) {
            headers.setAlgorithm(keyEncryptionAlgo);
            headers.setContentEncryptionAlgorithm(contentEncryptionAlgo);
            if (compression != null) {
                headers.setZipAlgorithm(compression);
            }
        }
        return headers;
    }

    private static JweEncryptionProvider createJweEncryptionProvider(KeyEncryptionAlgorithm keyEncryptionProvider, ContentEncryptionAlgorithm ctEncryptionProvider, String contentEncryptionAlgo, String compression) {
        if (keyEncryptionProvider == null && ctEncryptionProvider == null) {
            throw new SecurityException();
        }
        JweHeaders headers = JweUtils.prepareJweHeaders(keyEncryptionProvider != null ? keyEncryptionProvider.getAlgorithm() : null, contentEncryptionAlgo, compression);
        if (keyEncryptionProvider != null) {
            return JweUtils.createJweEncryptionProvider(keyEncryptionProvider, headers);
        }
        return new DirectKeyJweEncryption(ctEncryptionProvider);
    }

    private static JweDecryptionProvider createJweDecryptionProvider(KeyDecryptionAlgorithm keyDecryptionProvider, SecretKey ctDecryptionKey, String contentDecryptionAlgo) {
        if (keyDecryptionProvider == null && ctDecryptionKey == null) {
            throw new SecurityException();
        }
        if (keyDecryptionProvider != null) {
            return JweUtils.createJweDecryptionProvider(keyDecryptionProvider, contentDecryptionAlgo);
        }
        return JweUtils.getDirectKeyJweDecryption(ctDecryptionKey, contentDecryptionAlgo);
    }

    private static String getKeyEncryptionAlgo(Message m, Properties props, String algo, String defaultAlgo) {
        if (algo == null) {
            if (defaultAlgo == null) {
                defaultAlgo = "RSA-OAEP";
            }
            return KeyManagementUtils.getKeyAlgorithm(m, props, JSON_WEB_ENCRYPTION_KEY_ALGO_PROP, defaultAlgo);
        }
        return algo;
    }

    private static String getDefaultKeyAlgo(JsonWebKey jwk) {
        if ("oct".equals(jwk.getKeyType())) {
            return "A128GCMKW";
        }
        return "RSA-OAEP";
    }

    private static String getContentEncryptionAlgo(Message m, Properties props, String algo) {
        if (algo == null) {
            return KeyManagementUtils.getKeyAlgorithm(m, props, JSON_WEB_ENCRYPTION_CEK_ALGO_PROP, "A128GCM");
        }
        return algo;
    }

    private static String encrypt(KeyEncryptionAlgorithm keyEncryptionProvider, String contentAlgo, byte[] content, String ct) {
        JweEncryptionProvider jwe = JweUtils.createJweEncryptionProvider(keyEncryptionProvider, contentAlgo, null);
        return jwe.encrypt(content, JweUtils.toJweHeaders(ct));
    }

    private static byte[] decrypt(KeyDecryptionAlgorithm keyDecryptionProvider, String contentAlgo, String content) {
        JweDecryptionProvider jwe = JweUtils.createJweDecryptionProvider(keyDecryptionProvider, contentAlgo);
        return jwe.decrypt(content).getContent();
    }

    private static JweHeaders toJweHeaders(String ct) {
        return new JweHeaders(Collections.singletonMap("cty", ct));
    }
}

